// ------------------------------------------------
// --- RMIExamServer example

// --- imports
import java.lang.*;
import java.io.*;
import java.rmi.*;
import java.rmi.server.*;

public class RMIExamServer 
	extends UnicastRemoteObject 
	implements RMIExamMethods
{
	
	// ---
	public static final String defaultPort = "1099";
	public static final String defaultHost = "localhost";

	// --- ctor	
	public RMIExamServer() 
		throws RemoteException
	{
		System.out.println( "RMIExamServer()");
	}

	
	public String getTheAnswer(String question)
		throws RemoteException
	{
		System.out.println("RMIExamServer.getTheAnswer()");
		return new String(
			question.replace('?', '.') 
			+ "\nDoes not matter!"
			+ " The ANSWER IS: 42 !!!"
			);
	}

	// --- registration for RMI serving
	public static void main(String[] args) {
		System.out.println("RMIExamServer starting ...");
		System.setSecurityManager(new RMISecurityManager());
		try {
			String host;
			String port;
			if (args.length > 1) {
				host = args[0];
				port = args[1];
			} else if (args.length > 0) {
				host = args[0];
				port = defaultPort;
			} else {
				host = defaultHost;
				port = defaultPort;
			}	
			RMIExamServer exam = new RMIExamServer();
			//System.out.println("bind: " + "//" + host + ":" + port + "/RMIExamServer");
			Naming.bind("//" + host + ":" + port + "/RMIExamServer", exam);
			System.out.println("RMIExamServer ready to run !");
			
		} catch(AccessException e) {
			System.out.println("RMIExamServer: AccessException ");
			e.detail.printStackTrace();
		} catch(Exception e) {
			System.out.println("RMIExamServer: Exception: " + e.getMessage());
			e.printStackTrace();
		}
	}
}
