// ------------------------------------------------
// --- SerializeExam example

// --- imports
import java.lang.*;
import java.io.*;
import java.util.*;

// ---
public class SerializeExam {

	
	// --- main
	public static void main(String args[]) {
		System.out.println( "SerializeExam started ..." );
		try {
			if (args.length >= 2) {
				if (args[0].equals("load")) {
				
					ObjectInputStream in =
						new ObjectInputStream(
							new FileInputStream(
								new File(args[1])
							));
					Vector v = (Vector)in.readObject();
					System.out.println("SerializeExam - loaded vector:\n  " + vector2String(v));
					in.close();
					
				} else if (args[0].equals("save")) {

					Vector v = new Vector();
					for (int i = 0; i < 10; i ++) {
						v.addElement(new Data((int)(Math.random() * 100)));
					}
					System.out.println("SerializeExam - saving vector:\n  " + vector2String(v));
					ObjectOutputStream out =
						new ObjectOutputStream(
							new FileOutputStream(new File(args[1])
							));
					out.writeObject(v);
					out.close(); 

				} else {
					System.out.println( "unknown operation: " + args[0]);
					System.out.println( "usage: SerializeExam load|save filename" );
				}
			} else {
				System.out.println( "usage: SerializeExam load|save filename" );
			}
		} catch (Exception e) {
			System.out.println( "SerializeExam: Exception: " + e.getMessage());
			e.printStackTrace();
		}
	}



	// --- main
	public static String vector2String(Vector v) {
		StringBuffer buf = new StringBuffer();
		buf.append("[");
		Enumeration e = v.elements();
		boolean flag = false;
		while (e.hasMoreElements()) {
			if (flag) {
				buf.append(",");
			} else {
				flag = true;
			}
			Data d = (Data)e.nextElement();
			buf.append(d.toString());
		}
		buf.append("]");
		return buf.toString();
	}



	// --- my data
	public static class Data 
		// --- all you need is (yes love ofcourse too, but ...)
		implements Serializable
	{

		// --- ctor
		public Data(int i) {
			value = i;
			System.out.println("Data() - value = " + value);
		}
		
		// --- accessor
		public int getValue() { return value; }		
		
		// --- equals
		public boolean equals(Object obj) {
			return (((Data)obj).getValue() == this.getValue());
		}

		// --- toString
		public String toString() {
			return Integer.toString(value);
		}

		// --- value 
		private int value;
	}

}

