// -------------------------------------------------------------------------
// ThreadDemoApplet

// ---
import java.awt.*;
import java.util.*;
import java.applet.Applet;

// ----
public class ThreadDemoApplet 
	extends Applet 
{
	protected Thread running = null;
	protected Vector pics = null;
	
	public void init() {
		showStatus("Init");
		Panel pnl = new Panel();
		pnl.setLayout(new FlowLayout());
		pnl.add(new Button("Add"));
		pnl.add(new Button("Kill'em All"));
		setLayout(new BorderLayout());
		add("South", pnl);
		pics = new Vector();
		PicThread.gc = getGraphics();
		Dimension msize = size();
		msize.height -= 40;
		PicThread.gcSize = msize;
		PicThread.background = getBackground();
		System.out.println("Init");
	}
	
	public void start() {
		System.out.println("Start");
		showStatus("Start");
	}
	
	public void stop() {
		System.out.println("Stop");
		showStatus("Stop");
	}
	
	public boolean action(Event evt, Object arg) {
		System.out.println("action !");
		if (evt.target instanceof Button) {
			if ("Add".equals(arg)) {
				addPic();
			} else if ("Kill'em All".equals(arg)) {
				removePics();
			}
		}
		return true;
	}
	
	public void paint( Graphics g ) {
	}

	protected void addPic() {
		PicThread pt = new PicThread();
		pics.addElement(pt);
		pt.start();
		System.out.println("added");
	}
	
	protected void removePics() {
		Enumeration e = pics.elements(); 
		while (e.hasMoreElements()) {
			PicThread pt = (PicThread)e.nextElement();
			pt.stop();
		}
		pics.removeAllElements();
		update(getGraphics());
	}


	// -------------------------------------------------------
	// --- PicThread

	public static class PicThread extends Thread {
		public static Graphics gc = null;
		public static Dimension gcSize;
		public static Color background;	
	
		protected int xn, yn;
		protected Point pos = null;
		
		public PicThread() {
			super();
			pos = new Point(0, 0);
			xn = 1;
			yn = 1;
			randomize();
			gc.setXORMode(background);
			draw();
			gc.setPaintMode();
		}
		
		public void run() {
			while (true) {
				gc.setXORMode(background);
				draw();
				step();
				draw();
				gc.setPaintMode();
				try {
					sleep(10);
				} catch (InterruptedException e) {
				}
			}
		}
		
		public void draw() {
			gc.drawRect(pos.x, pos.y, 4, 4);
		}
		
		public void step() {
			if (
				((xn > 0) && ((xn + pos.x) < gcSize.width))
				|| ((xn < 0) && ((xn + pos.x) > 0))
			) {
				pos.x += xn;
			} else {
				xn = -xn;
			}
	
			if (
				((yn > 0) && ((yn + pos.y) < gcSize.height))
				|| ((yn < 0) && ((yn + pos.y) > 0))
			) {
				pos.y += yn;
			} else {
				yn = -yn;
			}
		}
		
		public void randomize() {
			pos.x = (int)(Math.random() * gcSize.width);
			pos.y = (int)(Math.random() * gcSize.height);
			xn = Math.random() > 0.5 ? 1 : -1;
			yn = Math.random() > 0.5 ? 1 : -1;
		}
	}

}


