// -----------------------------------------------------------------
// EqualsExam.java


// --- imports
import java.lang.*;
import java.io.*;

public class EqualsExam {

	// --- const
	public static final int MAGIC = 42;
	

	// --- main
	public static void main(String[] args) {	
		
		Integer i1 = new Integer(MAGIC);
		Integer i2 = new Integer(MAGIC);
		System.out.println("i1.equals(i2) ---> " + i1.equals(i2));
		
		Data d1   = new Data(MAGIC);
		Data d2   = new Data(MAGIC);
		System.out.println("d1.equals(d2) ---> " + d1.equals(d2));
		
	}
	

	// --- my data
	public static class Data {

		// --- ctor
		public Data(int i) {
			value = i;
		}
		
		// --- accessor
		public int getValue() { return value; }		
		
		// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		// !!! equals() return false by default
		// !!! you really need to override it
		// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		public boolean equals(Object obj) {
			return (((Data)obj).getValue() == this.getValue());
		}

		// --- value 
		private int value;
	}


}