// ------------------------------------------------
// --- RMIExamClient example

// --- imports
import java.lang.*;
import java.io.*;
import java.rmi.*;


public class RMIExamClient {
	
	// ---
	public static final String defaultPort = "1099";
	public static final String defaultHost = "localhost";


	// ---
	public static void main(String[] args) {
		System.out.println("RMIExamClient starting ...");
		System.setSecurityManager(new RMISecurityManager());
		try {
			String host;
			String port;
			if (args.length > 1) {
				host = args[0];
				port = args[1];
			} else if (args.length > 0) {
				host = args[0];
				port = defaultPort;
			} else {
				host = defaultHost;
				port = defaultPort;
			}	
			RMIExamMethods server = (RMIExamMethods)Naming.lookup(
				"//" + host + ":" + port + "/RMIExamServer"
				);
			
		} catch(Exception e) {
			System.out.println("RMIExamClient: Exception: " + e.getMessage());
			e.printStackTrace();
		}
		System.out.println("RMIExamClient done");
	}
}
