
// ------------------------------------------------
// --- SimpleClient example

// imports
import java.lang.*;
import java.io.*;
import java.net.*;

public class SimpleClient {

	// --- main
	public static void main(String args[]) {
		System.out.println( "SimpleClient started ..." );
		try {
			int port;
			try {
				if (args.length > 1) {
					port = Integer.parseInt(args[1]);
				} else {
					port = SimpleServer.defaultPort;
				}
			} catch (NumberFormatException e) {
				System.err.println(
					"NumberFormatException, using defaultPort ("
					+ SimpleServer.defaultPort 
					+ ")");
				port = SimpleServer.defaultPort;
			}
			String addr = (args.length > 0) ? args[0] : "127.0.0.1";
			new SimpleClient(addr, port).go();
			System.out.println("Simple Client ended !");
		} catch (Exception e) {
			System.out.println( "SimpleClient: IOException");
			e.printStackTrace();
		}
	}
	
	// --- ctor
	public SimpleClient(String addr, int port) {
		this.address = addr;
		this.port    = port;
	}
	
	// ---
	public void go() throws IOException {	
		System.out.println("SimpleClient connecting ...");
		int c;
		Socket sckt;
		InputStream instr;
		sckt = new Socket(InetAddress.getLocalHost(), port);
		instr = sckt.getInputStream();
		while ((c = instr.read()) != -1) {
			System.out.print((char)c);
		}
		System.out.println();
		sckt.close();
	}
	

	// --- 
	private int    port;
	private String address;
}
