// ------------------------------------------------
// --- SimpleJDBCExam example

// --- imports
import java.lang.*;
import java.io.*;
import java.net.*;
import java.sql.*;

public class SimpleJDBCExam {

	// ---
	public static final String defaultDBName    = "students";
	public static final String defaultDBColumns = "id int, fname char(40), lname char(60)";

	// ---
	public static final String[] defaultRecords = {
		"1, 'Anicka', 'Ruzickova'",
		"2, 'Janko', 'Mrkvicka'",
		"3, 'Ferko', 'Vrtulka'"
	};

	
	// --- main
	public static void main(String args[]) {
		System.out.println( "SimpleJDBCExam started ..." );
		try {
			try {
				if (args.length >= 4) {
				
					System.out.println("SimpleJDBCExam loading class for JDBC driver");
					Class.forName(args[0]);
	
					SimpleJDBCExam exam = new SimpleJDBCExam(args[1], args[2], args[3]);
					
					exam.connect();
					exam.create();
					exam.insert();
					exam.select();
					exam.update();
					exam.select();
					exam.delete();
					exam.drop();				
					exam.disconnect();
					
				} else {
					System.out.println( "usage: SimpleJDBCExam driverName url login passwd");
				}
			} catch(ClassNotFoundException e) {
				System.err.println("SimpleJDBCExam: ClassNotFoundException");
				e.printStackTrace();
			} catch(SQLException e) {
				System.err.println("SimpleJDBCExam: SQLException");
				e.printStackTrace();
			}
		} catch (Exception e) {
			System.out.println( "SimpleJDBCExam: Exception: " + e.getMessage());
			e.printStackTrace();
		}
		System.out.println( "SimpleJDBCExam ended !");
	}

	// --- ctor	
	public SimpleJDBCExam(String url, String login, String passwd)
		throws IOException
	{
		System.out.println( "SimpleJDBCExam()");
		this.urlString = url;
		this.login     = login;
		this.password  = passwd;
	}


	// --- connect to the database
	public void connect()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.connect()");
		connection = DriverManager.getConnection(urlString, login, password);
		stmt       = connection.createStatement();
	}
	
	// --- create exam's table
	public void create()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.create()");
		String query = "create table " + defaultDBName + " (" + defaultDBColumns + ")";
		//System.out.println( "query: " + query);
		stmt.executeUpdate(query);
	}
	
	// --- insert exam's records
	public void insert()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.insert()");
		for (int i = 0; i < defaultRecords.length; i++) {
			stmt.executeUpdate(
				"insert into " + defaultDBName + " values (" + defaultRecords[i] + ")" 
				);
		}
	}
	
	// --- select records
	public void select()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.select()");
		ResultSet rs = stmt.executeQuery("select * from students");
		int i = 1;
		System.out.println();
		System.out.println("Results:");
		while (rs.next()) {
			int    id = rs.getInt(1);
			String fn = rs.getString(2).trim();
			String ln = rs.getString(3).trim();
			System.out.println(
				i + ": " +
				"id='" + id + "', " +
				"fname='" + fn + "', " +
				"lname='" + ln + "'"
				);
		}
		System.out.println();
	}
	
	// --- update some records
	public void update()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.update()");
		stmt.executeUpdate(
			"update " + defaultDBName + " set lname='Ruzicka, rod. Esterhazy' where id=1'"
			);
	}
	
	// --- delete records
	public void delete()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.delete()");
		stmt.executeUpdate(
			"delete from students"
			);
	}
	
	// --- drop exam's table
	public void drop()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.drop()");
		stmt.executeUpdate(
			"drop table students"
			);
	}

	// --- disconnect from the database
	public void disconnect()
		throws SQLException
	{
		System.out.println( "SimpleJDBCExam.disconnect()");
		stmt.close();
		connection.close();
		connection = null;
	}

	
	// --- members
	private String       urlString;
	private String       login;
	private String       password;

	private Connection   connection;
	private Statement    stmt;

}
