// ------------------------------------------------
// --- SimpleServer example

// --- imports
import java.lang.*;
import java.io.*;
import java.net.*;

public class SimpleServer {

	// ---
	public static final int defaultPort = 6666;
	
	// --- main
	public static void main(String args[]) {
		System.out.println( "SimpleServer started ..." );
		try {
			int port;
			try {
				if (args.length > 0) {
					port = Integer.parseInt(args[0]);
				} else {
					port = defaultPort;
				}
			} catch (NumberFormatException e) {
				System.err.println( "NumberFormatException, using defaultPort (" + defaultPort + ")");
				port = defaultPort;
			}
			new SimpleServer(port).loop();
		} catch (IOException e) {
			System.out.println( "SimpleServer: IOException");
			e.printStackTrace();
		}
		System.out.println( "SimpleServer ended !");
	}

	// --- ctor	
	public SimpleServer(int port) throws IOException {
		this.port = port;
		this.server = new ServerSocket(port);
	}

	// --- "main loop"
	public void loop() throws IOException  {
		int len;
		OutputStream outstr;
		String sendstr = 
			"Here is some DATA: "+ 
			"001001000111100010011000100000010100010000010011010111\n";
		System.out.println( "SimpleServer waiting on accept ..." );
		// --- "never-ending loop"
		for (int n = 0; n < 10000000; n++ ) {
			socket = server.accept();
			outstr = socket.getOutputStream();
			len    = sendstr.length(); 
			System.out.println( "SimpleServer writting data ..." );
			for (int i = 0; i < len; i++) {
				outstr.write((int)sendstr.charAt(i));
			}
			socket.close();
		}
	}
	
	// --- members
	private int          port;
	private Socket       socket;
	private ServerSocket server;
}
