// -----------------------------------------------------------------
// StaticInitExam.java


// --- imports
import java.lang.*;
import java.io.*;

public class StaticInitExam {

	// --- const
	public static final int MAGIC = 42;
	

	// --- main
	public static void main(String[] args) {	
		
		System.out.println("st1 = " + st1);

		System.out.println("st2 = " + st2);
		
	}
	
	
	// ---
	public static Data st1 = new Data(MAGIC);

	// ---
	public static Data st2;


	// --- explicit static init
	static {
		st2 = new Data(MAGIC);
	}
	
	
	// --- my data
	public static class Data {

		// --- ctor
		public Data(int i) {
			value = i;
			System.out.println("Data() - value = " + value);
		}
		
		// --- accessor
		public int getValue() { return value; }		
		
		// --- equals
		public boolean equals(Object obj) {
			return (((Data)obj).getValue() == this.getValue());
		}

		// --- value 
		private int value;
	}


}