from sqlalchemy import create_engine, ForeignKey, Column, String, Integer
from sqlalchemy.orm import relationship, DeclarativeBase

engine = create_engine("sqlite:///my_database.sqlite", echo=True)


class Base(DeclarativeBase):
    pass

class User(Base):
    __tablename__ = 'user'
    id = Column(Integer, primary_key=True)
    name = Column(String)


class Group(Base):
    __tablename__ = 'group'
    id = Column(Integer, primary_key=True)
    name = Column(String)

class UserGroup(Base):
    __tablename__ = 'user_group'
    user_id = Column(ForeignKey('user.id'), primary_key=True)
    group_id = Column(ForeignKey('group.id'), primary_key=True)

    user = relationship("User", back_populates='groups')
    group = relationship("Group", back_populates='users')

# "secondary" parameter specifies the intermediary table for a many-to-many relationship
User.groups = relationship(secondary=UserGroup.__table__, back_populates='users')
Group.users = relationship(secondary=UserGroup.__table__, back_populates='groups')

# Drop tables if exist
Base.metadata.drop_all(engine)

# Create the tables in the database
Base.metadata.create_all(engine)
