from sqlalchemy import create_engine, ForeignKey, Table, Column
from sqlalchemy.orm import relationship, DeclarativeBase, Mapped, mapped_column

from typing import List

engine = create_engine("sqlite:///my_database.sqlite", echo=True)


class Base(DeclarativeBase):
    pass


user_group = Table(
    "user_group",
    Base.metadata,
    Column("user_id", ForeignKey("user.id"), primary_key=True),
    Column("group_id", ForeignKey("group.id"), primary_key=True),
)


class User(Base):
    __tablename__ = 'user'
    id: Mapped[int] = mapped_column(primary_key=True)
    name: Mapped[str]

    # "secondary" parameter specifies the intermediary table for a many-to-many relationship
    groups: Mapped[List["Group"]] = relationship(secondary=user_group, back_populates='users')


class Group(Base):
    __tablename__ = 'group'
    id: Mapped[int] = mapped_column(primary_key=True)
    name: Mapped[str]

    users: Mapped[List["User"]] = relationship(secondary=user_group, back_populates='groups')


# Drop tables if exist
Base.metadata.drop_all(engine)

# Create the tables in the database
Base.metadata.create_all(engine)
