#include <vector>
#include <string>
#include <iostream>
#include <algorithm>

class Person {
public: 
    std::string name;
    std::string country;    
    Person(std::string name_, std::string country_): name(name_), country(country_) {}
};

class person_has_country {
    std::string country_;
    public:
    person_has_country(std::string country) : country_(country) {};
    bool operator() (const Person &p) {
        return p.country==country_;
    }        
};


int main() {
    std::vector<Person> people;
    people.emplace_back("Jan", "Slovakia");
    people.emplace_back("Jan", "Czechia");
    people.emplace_back("Jan", "Netherlands");
    people.emplace_back("Jana", "Slovakia");

    // Slightly out of date code. From C++20 on we have ranges     
    auto it_dutch = std::find_if(people.begin(), people.end(), person_has_country("Netherlands"));
	
	// find_if(people, person_has_country_netherlands);
    
    if (it_dutch == people.end())
        std::cout<<"We have no Dutch here.\n";
    else
        std::cout<<"I found somebody Dutch, it is " + it_dutch->name + ".\n";

}
