# Komentare ku vzoraku 

Toto je moje [vzorove riesenie](vzorak.png). Okrem toho, ze kazda trieda pri svojej zmene okrem svojej navratovej hodnoty vracia svoj novy stav je potrebne si dat pozor na niekolko veci. Na rozdiel od objektovo orientovaneho programovania, nie je take jednoduche mat referenciu na iny objekt, lebo nemusi byt aktualna. Toto si mozeme dovolit iba ak mame dobre definovanu vlastnicku strukturu. A ted, ak trieda vlastni referenciu na inu triedu, tato referencia je aktualna. 

1. Triedy ako Floor ktore maju do UsedTiles pridavat dlazdce nemozu mat referenciu. Bud dostanu UsedTiles a vratia novu hodnotu tejto triedy, alebo vratia dlazdice co maju padnut na zem. Z hladiska znizenia zavislosti medzi vzdialenymi castami dizajnu preferujem druhu moznost. Potrebujeme preto v interfaci naseho podsystemu volanie, ktore prida dlazdice do UsedTiles. 
2. Kedze mame viac instancii Factory, nemozu vlsatnit referenciu na TableCenter ci Bag. Potrebujeme ine riesenie. Tu som sa rozhodol, ze potrebne instancie dostane trieda pri vo volani metod. Samozrejme, musi vratit zmenene instancie.
3. Nahodnost. Toto som pri opravovani prilis neriesil, ale je dolezite si na to dat pozor. Zavolanie globalneho randomu je side effect, ktory si vo funkcionalnom programovani nemozeme dovolit. S generatootom nahodnych cisel je spojeny stav. Tento stav moze byt ulozeny but v Bagu, alebo v RandomTileChoice. Ked ho dame do Bagu, v interfaci musime odovzdat sucasny stav nahodneho generatora, a asi aj tak musime vratit novy stav nahodneho generatora (aby sme nepouzivali rovnake vystupy generatora opakovane, lebo ktohovie, kolkokrat a ako sa pouzije). Toto sa trosku lahsie mockuje, ale nie som is isty ci je to vyhra, lebo je vzdy lepsie mat v testoch immutable mocky. Prirodzenejsie je mat stav generatora v RandomTileChoice. Mocky budu potom vyzerat napriklad takto:

Konstruktor moze  brat ocakavane vstupy, a ocakavane vystupy
MyMock(vstupne-dlazdice, pocet, vybrane-dlazdice, vrateny-objekt)
A nasledne piseme vnoreny kod.

MyMock(..., 1, ...,
  MyMock(..., 3, ...,
     MyMock(..., 2, ..., 
       MyMock())))
       
Pre neskusene oko to vyzera divne, ale v skutocnosti to nie je nic komplikovane, da sa na to zvyknut. Takyto Mock je immutable a teda sa ma vlastnosti, ktore testovany kod ocakava.

4. Treba si dat pozor na to ako sa napise generovanie nahodnych cisel, aby to naozaj bolo immutable. Napr si urobit lokalnu premennu Random, inicializovat ju z kopie stavu Random.getstate() a Random.setstate(). 

Aby sme umoznili testovanie po castiach, Kazdy objekt mozeme skryt za interface, aby sme ho mohli nahradit testovacim dvojnikom. Kedze trieda vracia nove verzie seba samej, nedava zmysel interfaci delit na mensie casti, kedze nakoniec aj tak moze byt najnovsia referencia pouzita lubovolnym sposobom.

# Alternativne riesenie

V [alternativnom rieseni](alternativa.png) separujeme data od metod. Inak ale vacsinu veci mozeme robit uplne rovnako. Tym ze data su separovane ziskavame schopnost delit interfaci na mensie casti. Napriklad Floor naozaj potrebuje iba funkciu, ktora zoberie UsedTiles a vrati nove UsedTiles, pripadne funkciu, ktora zoberie TableArea a vrati novu verziu TableArea. Tuto funkciu mozeme injectovat ako parameter do funkcii spravujucich napr floor. A potom je mozne funkcie spravne poskladat factory kodom podobne ako v OO paradigme. 

