# Assignment - Azul game, TableArea component 

Your task is to design and partially implement TableArea component of Azul game using functional programming. 

## Design

You should modify the original [OO design](design.png) sketch of TableArea component, roughly comprising of classes TableArea, TileSource, Factory, TableCenter, Bag, UsedTiles. The aim of the modification is to turn the OO paradigm to functional programming. This includes the use of immutable data structures and pure functions (which should be class methods, to keep basic correspondence between the old and new design). Also, the resulting design should be implementation-level design, that is, containing all elements that need to be implemented and containing all publicly visible attributes and behaviors (including constructors).

To accomplish this you must start by clarifying the assignment by defining the component boundary (interface you need to implement) as this also needs to change. While modifying the design, note that
1. You probably need some common root of TableArea and Bag not including Game class implementing your new interface. Do not forget about requirements related to interactions involving UsedTiles class with classes outside of the component.

2. You need to handle inherent randomness of Bag class by encapsulating the randomness to some small class. Your design should allow for writing reasonable tests, bypassing randomness, keeping only this minimal class untested.

3. The structure of associations needs to change to match data structure you need. 

## Implementation

You should implement classes Bag (excluding the random aspect separated from the class in the design phase) and Factory classes, including basic unit tests. You may do the implementation in any language of your choice and you do not need to adhere to type system requirements from the original assignment.

## Instructions for submitting your project

Send your solution to [lukotka.pts@gmail.com](lukotka.pts@gmail.com). The deadline is 29.11.2024 23:59:59. The solutions sent later will be accepted, however the number of points awarded may be reduced.

Send the solution to me either as s compressed folder containing a diagram capturing design and source files implementing the classes (and possible related interfaces and trivial types) plus their unit tests.


