#include <iostream>
#include <vector>
#include<map>
#include<string>

int main() {
    //iterators - a way to work with collections
    std::vector<int> v{1, 2, 3};
    std::map<int, std::string> m{{1, "a"}, {2, "b"}};
    
    for(int el: v) {
        std::cout<<el;
    }
    std::cout<<"\n";

    for(auto el: m) {
        std::cout<<el.first;
    }
    std::cout<<"\n";

    for(auto [key, value]: m) {
        std::cout<<key;
    }
    std::cout<<"\n";

    for(auto const& [key, value]: m) {
        std::cout<<key;
    }
    std::cout<<"\n";
    
    //iterator invalidation
    auto it = v.begin();
    v.push_back(3);
    // *it; undefined behavior vector may reallocate
    it = v.begin();
    //this is how you can keep your iterator valid
    it = v.insert(it, 3);
    //this is necessary if you want to make efficient collections
    
    //if we want pushback
    v.reserve(10);
    it = v.begin();
    v.push_back(3);
    //it is guaranteed to be valid
    
    // searching in collections. S bit clumsy using iterators
    std::find(v.begin(), v.end(), 6) == v.end();
    
    //ranges    
    //see example https://en.cppreference.com/w/cpp/ranges
    //https://en.cppreference.com/w/cpp/algorithm/ranges/find
}
