#include <iostream>

//This is functor
//A class with overloaded operator ()
auto is_even = [] (int a) -> bool {return a%2 == 0;};

//functor can be generic
//this will work for whatever type such that a%2 is defined and
auto is_even2 = [] (auto a) -> bool {return a%2 == 0;};

struct Other {
	int operator%(int i) const {
		return i;
	}
};

struct IsEven {
	template<typename T>
	bool operator()(const T& value) {return value%2 == 0;}
} is_even3;

int main() {
	std::cout<<is_even(7)<<" "<<is_even2(8)<<" "<<is_even2(Other())<<" "<<is_even3(Other())<<"\n";
	int a = 7;
	auto f = [&] (int b) {return a+b;};
	std::cout << f(8) <<"\n";
	return 0;
}
