# database.py
from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker, declarative_base
from config import DB_URL

# create declarative base
Base = declarative_base()

# create engine
engine = create_engine(DB_URL, echo=True)  # echo=True for SQL debugging

# create session factory
SessionLocal = sessionmaker(bind=engine)

# dependency function for sessions
def get_session():
    session = SessionLocal()
    try:
        yield session
    finally:
        session.close()
