# models.py

# custom ORM types - ORM knows how to translate them to supported databases
from sqlalchemy import Column, Integer, String, DateTime
from datetime import datetime
from database import Base

class Customer(Base):
    __tablename__ = 'customers'
    
    customerId = Column(Integer, primary_key=True, autoincrement=True)
    firstName = Column(String(10), nullable=False)
    middleName = Column(String(20), nullable=True)
    lastName = Column(String(25), nullable=False)
    eMail = Column(String(30), nullable=False)
    phone = Column(String(30), nullable=False)
    created = Column(DateTime, nullable=False, default=datetime.utcnow)
    lastModified = Column(DateTime, nullable=False, default=datetime.utcnow, onupdate=datetime.utcnow)

    