import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.tree.*;

public class InfixToPrefixListener extends GramatikaBaseListener {

    @Override 
    public void visitTerminal(TerminalNode node) {
        Token tok = node.getSymbol();
        if (tok.getType() == GramatikaParser.NEWLINE) {
            System.out.println();
        } 
    }

    @Override 
    public void enterBinOp(GramatikaParser.BinOpContext ctx) {
        System.out.print(ctx.op.getText() + " ");
    }
    
    @Override 
    public void enterNegParen(GramatikaParser.NegParenContext ctx) { 
        System.out.print("m ");
    }
    
    @Override 
    public void enterNumber(GramatikaParser.NumberContext ctx) { 
       System.out.print(ctx.NUM().getSymbol().getText() + " ");
    }
    
    @Override 
    public void enterNegNumber(GramatikaParser.NegNumberContext ctx) { 
       System.out.print("m " + ctx.NUM().getSymbol().getText() + " ");
    }
    

}