lexer grammar LexikalnePravidla;

NUM
    :    DIGIT+
    ;
    
fragment DIGIT
    :    [0-9]
    ;
    
ADD
    :    '+'
    ;
    
SUB
    :    '-'
    ;
    
MUL
    :    '*'
    ;
    
DIV
    :    '/'
    ;
    
LEFT
    :    '('
    ;
    
RIGHT
    :    ')'
    ;
    
NEWLINE
    :    ('\r\n' | '\n' | '\r')
    ;
    
WS
    :    [ \t]+ -> skip
    ;
