import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.tree.*;
import java.io.*;
import java.util.*;

public class Hlavna {

     public static void main(String[] args) throws Exception {
     
         InputStream is = System.in;
         if (args.length > 0) {
             is = new FileInputStream(args[0]);
         }
         CharStream input = CharStreams.fromStream(is);
         GramatikaLexer lexer = new GramatikaLexer(input);
         CommonTokenStream tokens = new CommonTokenStream(lexer);
         GramatikaParser parser = new GramatikaParser(tokens);
         
         ParseTree tree = parser.init();
         
         KalkVisitor visitor = new KalkVisitor();
         visitor.visit(tree);
     
     }

}