import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.tree.*;
import java.io.*;
import java.util.*;

public class KalkVisitor extends GramatikaBaseVisitor<Integer> {

    @Override
    public Integer visitExprStat(GramatikaParser.ExprStatContext ctx) { 
        int value = visit(ctx.expr());
        System.out.println(Integer.toString(value));
        return value;
    }
    
    @Override
    public Integer visitBinOp(GramatikaParser.BinOpContext ctx) {
        int value1 = visit(ctx.expr(0));
        int value2 = visit(ctx.expr(1));
        int value = 0;
        if (ctx.op.getType() == GramatikaParser.ADD) {
            value = value1 + value2;
        }
        if (ctx.op.getType() == GramatikaParser.SUB) {
            value = value1 - value2;
        }
        if (ctx.op.getType() == GramatikaParser.MUL) {
            value = value1 * value2;
        }
        if (ctx.op.getType() == GramatikaParser.DIV) {
            value = value1 / value2;
        }
        return value;
    }
    
    @Override
    public Integer visitParen(GramatikaParser.ParenContext ctx) { 
        return visit(ctx.expr());
    }
    
    @Override
    public Integer visitNegParen(GramatikaParser.NegParenContext ctx) { 
        return (-1) * visit(ctx.expr());
    }
    
    @Override
    public Integer visitNumber(GramatikaParser.NumberContext ctx) {
        return Integer.valueOf(ctx.NUM().getText());
    }
    
    @Override
    public Integer visitNegNumber(GramatikaParser.NegNumberContext ctx) {
        return (-1) * Integer.valueOf(ctx.NUM().getText());
    }


}