grammar Gramatika;

import LexikalnePravidla;

init
    :    stat* EOF
    ;
    
stat
    :    statbody? NEWLINE
    |    statbody EOF
    ;
    
statbody
    :    expr                                    # ExprStat
    |    ID ASSIGN expr                          # Assignment
    |    CLR                                     # Clear
    |    FOR ID lower=NUM upper=NUM DO statbody  # For
    ;
    
expr
    :    <assoc=right> expr op=POW expr        # BinOp
    |    expr op=(MUL|DIV) expr                # BinOp
    |    expr op=(ADD|SUB) expr                # BinOp
    |    LEFT expr RIGHT                       # Paren
    |    SUB LEFT expr RIGHT                   # NegParen
    |    NUM                                   # Number
    |    SUB NUM                               # NegNumber
    |    ID                                    # Identifier
    |    SUB ID                                # NegIdentifier
    ;

