import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.tree.*;
import java.io.*;
import java.util.*;

public class KalkVisitor extends GramatikaBaseVisitor<Integer> {

    Map<String,Integer> memory = new HashMap<String,Integer>();

    @Override
    public Integer visitAssignment(GramatikaParser.AssignmentContext ctx) {
        String id = ctx.ID().getText();
        int value = visit(ctx.expr());
        memory.put(id,value);
        return value;
    }

    @Override
    public Integer visitExprStat(GramatikaParser.ExprStatContext ctx) { 
        int value = visit(ctx.expr());
        System.out.println(Integer.toString(value));
        return value;
    }
    
    @Override
    public Integer visitBinOp(GramatikaParser.BinOpContext ctx) {
        int value1 = visit(ctx.expr(0));
        int value2 = visit(ctx.expr(1));
        int value = 0;
        if (ctx.op.getType() == GramatikaParser.ADD) {
            value = value1 + value2;
        }
        if (ctx.op.getType() == GramatikaParser.SUB) {
            value = value1 - value2;
        }
        if (ctx.op.getType() == GramatikaParser.MUL) {
            value = value1 * value2;
        }
        if (ctx.op.getType() == GramatikaParser.DIV) {
            value = value1 / value2;
        }
        if (ctx.op.getType() == GramatikaParser.POW) {
            value = 1;
            for (int i = 1; i <= value2; i++) {
                value = value * value1;
            }
        }
        return value;
    }
    
    @Override
    public Integer visitParen(GramatikaParser.ParenContext ctx) { 
        return visit(ctx.expr());
    }
    
    @Override
    public Integer visitNegParen(GramatikaParser.NegParenContext ctx) { 
        return (-1) * visit(ctx.expr());
    }
    
    @Override
    public Integer visitNumber(GramatikaParser.NumberContext ctx) {
        return Integer.valueOf(ctx.NUM().getText());
    }
    
    @Override
    public Integer visitNegNumber(GramatikaParser.NegNumberContext ctx) {
        return (-1) * Integer.valueOf(ctx.NUM().getText());
    }
    
    @Override 
    public Integer visitIdentifier(GramatikaParser.IdentifierContext ctx) { 
        String id = ctx.ID().getText();
        if (memory.containsKey(id)) {
            return memory.get(id);
        }
        else {
            return 0;
        }
    }
    
    @Override 
    public Integer visitNegIdentifier(GramatikaParser.NegIdentifierContext ctx) { 
        String id = ctx.ID().getText();
        if (memory.containsKey(id)) {
            return (-1) * memory.get(id);
        }
        else {
            return 0;
        }
    }
    
    @Override
    public Integer visitClear(GramatikaParser.ClearContext ctx) { 
        memory.clear(); 
        return 0;
    }
    
    @Override 
    public Integer visitFor(GramatikaParser.ForContext ctx) { 
        String id = ctx.ID().getText();
        int low = Integer.valueOf(ctx.lower.getText());
        int upp = Integer.valueOf(ctx.upper.getText());
        for (int i = low; i <= upp; i++) {
            memory.put(id,i);
            visit(ctx.statbody());
        }
        memory.put(id,0);
        return 0;
    }


}