grammar Gramatika;

import LexikalnePravidla;

@parser::header {
import java.io.*;
import java.util.*;
}

@parser::members {
    Map<String,Integer> memory = new HashMap<String,Integer>();

    int evalBinOp(int value1, int opType, int value2) {
        int value = 0;
        switch (opType) {
            case ADD : value = value1 + value2;
                       break;
            case SUB : value = value1 - value2;
                       break;
            case MUL : value = value1 * value2;
                       break;
            case DIV : value = value1 / value2;
                       break;
            case POW : value = 1;
                       for (int i = 1; i <= value2; i++) {
                           value = value * value1;
                       }
                       break;           
        }
        return value;
    }

}

init
    :    stat* EOF
    ;
    
stat
    :    statbody? NEWLINE
    |    statbody EOF
    ;
    
statbody
    :    expr {System.out.println($expr.v);}                   
    |    ID ASSIGN expr {memory.put($ID.text,$expr.v);}         
    |    CLR {memory.clear();}                     
    ;
    
expr returns [int v]
    :    <assoc=right> e1=expr op=POW e2=expr {$v = evalBinOp($e1.v,$op.type,$e2.v);}       
    |    e1=expr op=(MUL|DIV) e2=expr {$v = evalBinOp($e1.v,$op.type,$e2.v);}               
    |    e1=expr op=(ADD|SUB) e2=expr {$v = evalBinOp($e1.v,$op.type,$e2.v);}               
    |    LEFT expr RIGHT {$v = $expr.v;}                     
    |    SUB LEFT expr RIGHT {$v = (-1) * $expr.v;}                  
    |    NUM {$v = $NUM.int;}                                  
    |    SUB NUM {$v = (-1) * $NUM.int;}                              
    |    ID                   
         {
             String id = $ID.text;
             if (memory.containsKey(id)) {
                 $v = memory.get(id);
             }
             else {
                 $v = 0;
             }
         }                
    |    SUB ID     
         {
             String id = $ID.text;
             if (memory.containsKey(id)) {
                 $v = (-1) * memory.get(id);
             }
             else {
                 $v = 0;
             }
         }                                          
    ;

