lexer grammar LexikalnePravidla;

NUM
    :    DIGIT+
    ;

CLR
    :    'clear'
    ;
    
ID
    :    LETTER (LETTER|DIGIT)*
    ;    
    
fragment DIGIT
    :    [0-9]
    ;
    
fragment LETTER
    :    [a-zA-Z]
    ;
    
ASSIGN
    :    '='
    ;
    
ADD
    :    '+'
    ;
    
SUB
    :    '-'
    ;
    
MUL
    :    '*'
    ;
    
DIV
    :    '/'
    ;
    
POW
    :    '^'
    ;
    
LEFT
    :    '('
    ;
    
RIGHT
    :    ')'
    ;
    
NEWLINE
    :    ('\r\n' | '\n' | '\r')
    ;
    
WS
    :    [ \t]+ -> skip
    ;
