import org.antlr.v4.runtime.*;
//import org.antlr.v4.runtime.tree.*;
import java.io.*;
import java.util.*;

public class Pocitadlo {

     public static void main(String[] args) throws Exception {
    
         CharStream input = CharStreams.fromStream(System.in);
         Gramatika lexer = new Gramatika(input);
         CommonTokenStream tokens = new CommonTokenStream(lexer);
         Vocabulary voc = lexer.getVocabulary();
         
         tokens.fill();
         List<Token> list = tokens.getTokens();
         Iterator<Token> it = list.iterator();
         
         int pNieco = 0, pNiecoIne = 0, pSlovo = 0, pCislo = 0;
         
         while (it.hasNext()) {
             Token tok = it.next();
             int type = tok.getType();
             String symbolic = voc.getSymbolicName(type);
             if (symbolic.equals("Nieco")) {
                 pNieco++;
             }
             if (symbolic.equals("NiecoIne")) {
                 pNiecoIne++;
             }
             if (symbolic.equals("Slovo")) {
                 pSlovo++;
             }
             if (symbolic.equals("Cislo")) {
                 pCislo++;
             }
         }
         
         System.out.println("Nieco: " + Integer.toString(pNieco) + " vyskytov");
         System.out.println("NiecoIne: " + Integer.toString(pNiecoIne) + " vyskytov");
         System.out.println("Slovo: " + Integer.toString(pSlovo) + " vyskytov");
         System.out.println("Cislo: " + Integer.toString(pCislo) + " vyskytov");
     
     } 

}