import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.tree.*;
import java.io.*;
import java.util.*;

public class Compiler {

     public static void main(String[] args) throws Exception {
         String inputFile = null;
         String outputFile = null;
         int i = 0;
         while (i < args.length) {
             if (args[i].equals("-o")) {
                 if (i < args.length - 1) {
                     outputFile = new String(args[i+1]);
                     i += 2;
                 }
                 else {
                     throw new IllegalArgumentException();
                 }
             } 
             else {
                 inputFile = new String(args[i]);
                 i++;
             }
         }
         InputStream is = System.in;
         if (inputFile != null) {
             is = new FileInputStream(inputFile);
         }
         PrintStream ps = System.out;
         if (outputFile != null) {
             ps = new PrintStream(new FileOutputStream(outputFile));
         }
        
         CharStream input = CharStreams.fromStream(is);
         GramatikaLexer lexer = new GramatikaLexer(input);
         CommonTokenStream tokens = new CommonTokenStream(lexer);
         GramatikaParser parser = new GramatikaParser(tokens);
         
         ParseTree tree = parser.init();
         
         CompilerVisitor visitor = new CompilerVisitor();
         CodeFragment code = visitor.visit(tree);
         ps.print(code.toString());
     }
}