grammar Gramatika;

import LexikalnePravidla;

init
    :    stat* EOF
    ;
    
stat
    :    statbody? NEWLINE
    |    statbody EOF
    ;
    
statbody
    :    expr                                                                        # ExprStat
    |    ID ASSIGN expr                                                              # Assignment
    |    CLR                                                                         # Clear
    |    FOR ID lower=NUM upper=NUM DO statbody                                      # For
    |    IF expr rel=(EQ|NEQ|LT|GT|LEQ|GEQ) expr THEN t=statbody (ELSE f=statbody)?  # Condition
    |    block                                                                       # BlockStat
    ;
    
expr
    :    <assoc=right> expr op=POW expr        # BinOp
    |    expr op=(MUL|DIV) expr                # BinOp
    |    expr op=(ADD|SUB) expr                # BinOp
    |    LEFT expr RIGHT                       # Paren
    |    SUB LEFT expr RIGHT                   # NegParen
    |    NUM                                   # Number
    |    SUB NUM                               # NegNumber
    |    ID                                    # Identifier
    |    SUB ID                                # NegIdentifier
    ;

block
    :    BEGIN NEWLINE stat+ END
    ;