lexer grammar LexikalnePravidla;

NUM
    :    DIGIT+
    ;

CLR
    :    'clear'
    ;
    
FOR
    :    'for'
    ;
    
DO
    :    'do'
    ;
    
IF
    :    'if'
    ;
    
THEN
    :    'then'
    ;
    
ELSE
    :    'else'
    ;    
    
BEGIN
    :    'begin'
    ;
    
END
    :    'end'
    ;    
    
ID
    :    LETTER (LETTER|DIGIT)*
    ;    
    
fragment DIGIT
    :    [0-9]
    ;
    
fragment LETTER
    :    [a-zA-Z]
    ;
    
EQ
    :    '=='
    ;
    
NEQ
    :    '!='
    ;
    
LT
    :    '<'
    ;
    
GT
    :    '>'
    ;
    
LEQ
    :    '<='
    ;
    
GEQ
    :    '>='
    ;
    
ASSIGN
    :    '='
    ;
    
ADD
    :    '+'
    ;
    
SUB
    :    '-'
    ;
    
MUL
    :    '*'
    ;
    
DIV
    :    '/'
    ;
    
POW
    :    '^'
    ;
    
LEFT
    :    '('
    ;
    
RIGHT
    :    ')'
    ;
    
NEWLINE
    :    ('\r\n' | '\n' | '\r')
    ;
    
WS
    :    [ \t]+ -> skip
    ;
