import FIFARankingStrategy
import unittest


class TestFIFARankingStrategy(unittest.TestCase):
    class StubPosition:
        pass
    class StubTeam:
        pass
    class StubMatchReport:
        pass 
    class StubFIFARanking:
        def teamPosition(self, s):
            if s=="Germany":
                return 1
            if s=="France":
                return 2
            if s=="England":
                return 3
            self.assertEqual(0, 1)
            return 1


    def setUp(self):      
        self.germany=self.StubPosition()
        self.germany.reports=[]
        self.germany.team=self.StubTeam()
        self.germany.team.name="Germany" 
        self.france=self.StubPosition()
        self.france.reports=[]        
        self.france.team=self.StubTeam()
        self.france.team.name="France" 
        
        FIFARanking=self.StubFIFARanking()
        self.rankingStrategy=FIFARankingStrategy.FIFARankingStrategy(FIFARanking)
        

    def test_upper(self):
        self.assertEqual('foo'.upper(), 'FOO')
   
    def test_if_no_matches_were_played_everything_is_zero_and_FIFA_ranking_decides_the_ranking(self):
        (permutation, info)=self.rankingStrategy.rank([self.germany, self.france])
        self.assertEqual(len(permutation), 2)
        self.assertEqual(len(info), 2)
        self.assertEqual(permutation[0], 0)
        self.assertEqual(permutation[1], 1)
        self.assertEqual(info[0].position, 1)
        self.assertEqual(info[0].points, 0)
        self.assertEqual(info[0].goalsFor, 0)
        self.assertEqual(info[0].goalsAgainst, 0)
        self.assertEqual(info[0].yellowCards, 0)
        self.assertEqual(info[0].redCards, 0)
        self.assertEqual(info[1].position, 2)
        self.assertEqual(info[1].points, 0)
        self.assertEqual(info[1].goalsFor, 0)
        self.assertEqual(info[1].goalsAgainst, 0)
        self.assertEqual(info[1].yellowCards, 0)
        self.assertEqual(info[1].redCards, 0)
        (permutation, info)=self.rankingStrategy.rank([self.france, self.germany])
        self.assertEqual(permutation[0], 1)
        self.assertEqual(permutation[1], 0)
        self.assertEqual(info[1].position, 2)
        self.assertEqual(info[0].position, 1)

    def test_if_team_has_more_points_it_is_first(self):
        mr=self.StubMatchReport()
        mr.teams=["Germany", "France"]
        mr.goals=[1, 2]
        mr.yellowCards=[4, 3]
        mr.redCards=[2, 1]
        mr.report=[]
        self.germany.reports.append(mr)
        self.france.reports.append(mr)
        (permutation, info)=self.rankingStrategy.rank([self.germany, self.france])
        self.assertEqual(len(permutation), 2)
        self.assertEqual(len(info), 2)
        self.assertEqual(permutation[0], 1)
        self.assertEqual(permutation[1], 0)
        self.assertEqual(info[1].position, 2)
        self.assertEqual(info[1].points, 0)
        self.assertEqual(info[1].goalsFor, 1)
        self.assertEqual(info[1].goalsAgainst, 2)
        self.assertEqual(info[1].yellowCards, 4)
        self.assertEqual(info[1].redCards, 2)
        self.assertEqual(info[0].position, 1)
        self.assertEqual(info[0].points, 3)
        self.assertEqual(info[0].goalsFor, 2)
        self.assertEqual(info[0].goalsAgainst, 1)
        self.assertEqual(info[0].yellowCards, 3)
        self.assertEqual(info[0].redCards, 1)


    def test_if_the_match_ends_draw_both_teams_have_one_point_as_everything_is_equal_FIFA_ranking_decides(self):
        mr=self.StubMatchReport()
        mr.teams=["Germany", "France"]
        mr.goals=[1, 1]
        mr.yellowCards=[0, 0]
        mr.redCards=[0, 0]
        mr.report=[]
        self.germany.reports.append(mr)
        self.france.reports.append(mr)
        (permutation, info)=self.rankingStrategy.rank([self.germany, self.france])
        self.assertEqual(permutation[0], 0)
        self.assertEqual(permutation[1], 1)
        self.assertEqual(info[0].position, 1)
        self.assertEqual(info[0].points, 1)
        self.assertEqual(info[0].goalsFor, 1)
        self.assertEqual(info[0].goalsAgainst, 1)
        self.assertEqual(info[1].position, 2)
        self.assertEqual(info[1].points, 1)
        self.assertEqual(info[1].goalsFor, 1)
        self.assertEqual(info[1].goalsAgainst, 1)
        
if __name__ == '__main__':
    unittest.main()

