import FIFARankingStrategy

@given('{team1} played with <team2> with result <goals1> : <goals2>')
def step_impl(context, team1, team2, goals1, goals2):
    class StubReport:
	    pass
    context.team[team1].reports=[StubReport()]
    context.team[team2].reports=[StubReport()]
	


@given('The following teams are in the group')
def step_impl(context):
    class StubPosition:
        pass
    class StubTeam:
        pass
    for row in context.table:
        team=row['team']
        rank=row['rank']
        context.rankingStrategy.FIFARanking.teams[team]=rank
        context.teams[team]=StubPosition()
        context.teams[team].reports=[]
        context.teams[team].team=StubTeam()
        context.teams[team].team.name=team 

@given('{team} is in the group and it is rank {rank} in the FIFA ranking')
def step_impl(context, team, rank):
    class StubPosition:
        pass
    class StubTeam:
        pass
    context.rankingStrategy.FIFARanking.teams[team]=rank
    context.teams[team]=StubPosition()
    context.teams[team].reports=[]
    context.teams[team].team=StubTeam()
    context.teams[team].team.name=team 



@given('No matches were played')
def step_impl(context):
    pass



@when('We ask to rank teams')
def step_impl(context):
    context.order=context.rankingStrategy.rank(list(context.teams.values()))


@then('{team} has rank {rank}')
def step_impl(context, team, rank):
    rank=int(rank)
    assert context.order[team].position==rank

@then('{team} has {number} points')
def step_impl(context, team, number):
    number=int(number)
    assert context.order[team].points==number



@then('Teams have the following ranks')
def step_impl(context):
    for row in context.table:
        team=row['team']
        rank=int(row['rank'])
        assert context.order[team].position==rank

@then('Teams have the following number of points')
def step_impl(context):
    for row in context.table:
        team=row['team']
        number=int(row['points'])
        assert context.order[team].points==number


