#include <vector>
#include <string>
#include <iostream>
#include <algorithm>
#include <memory>

class Person {
public: 
    std::string name;
    std::string country;    
    std::vector<std::weak_ptr<Person>> friends;

    Person(std::string name_, std::string country_): name(name_), country(country_) {}
    
    void make_friend(std::shared_ptr<Person> person) {friends.emplace_back(person);}
};

class person_has_country {
    std::string country_;
    public:
    person_has_country(std::string country) : country_(country) {};
    bool operator() (std::shared_ptr<Person> p) {
        return p->country==country_;
    }        
};


template<class P>
class person_has_friend {
    P predicate_;
    public:

    person_has_friend(P predicate): predicate_(predicate) {};

    bool operator() (std::shared_ptr<Person> p) {
        for(auto wptr : p->friends) {
            auto sptr =wptr.lock();           
            if (sptr && predicate_(sptr)) return true;
        }
        return false;
    }
};


int main() {
    std::vector<std::shared_ptr<Person>> people;
    people.emplace_back(std::make_shared<Person>("Jan", "Slovakia"));
    people.emplace_back(std::make_shared<Person>("Jan", "Czechia"));
    people.emplace_back(std::make_shared<Person>("Jan", "Netherlands"));
    people.emplace_back(std::make_shared<Person>("Jana", "Slovakia"));

    people[0]->make_friend(people[1]);
    people[3]->make_friend(people[0]);
    people[3]->make_friend(people[1]);
    people[3]->make_friend(people[2]);
    
    auto has_dutch_friend(person_has_friend<person_has_country>(person_has_country("Netherlands")));

    auto it_has_dutch_friend=std::find_if(people.begin(),people.end(),has_dutch_friend);    
    if (it_has_dutch_friend==people.end())
        std::cout<<"We have nobody with a Dutch friend here.\n";
    else
        std::cout<< (*it_has_dutch_friend)->name + " has a Dutch friend.\n";
    
    
    people.erase(people.begin()+2);
    it_has_dutch_friend=std::find_if(people.begin(),people.end(),has_dutch_friend);    
    if (it_has_dutch_friend==people.end())
        std::cout<<"We have nobody with a Dutch friend here.\n";
    else
        std::cout<< (*it_has_dutch_friend)->name + " has a Dutch friend.\n";
    

}
