#include <vector>
#include <iostream>
#include <utility>

/*
This example usses ba_graph libraty available at
https://bitbucket.org/relatko/ba-graph/
You just need the include folder. To compile this use
$(CXX) -std=c++17 -fconcepts -I <include folder name> example5.cpp -o a.out
You need g++ version >8.0.0.

The interesting classes for this example are:
/include/impl/basic/mappers.hpp
/include/impl/basic/mapping.hpp
*/
#include <impl/basic/include.hpp>


using namespace ba_graph;


//what if I want to return the new vertex???
template<typename T=NoMapper> 
typename OneExtraReturnValue<Vertex, T>::ReturnType  
        ends_to_new_vertex(Graph &g, const std::vector<Location> &v, 
                           Factory &f=static_factory) {
    typename T::MappingType mapping;
    Number n=addV(g,f);
    for (auto loc: v) {
        Location new_loc=Location(loc.n1, n);        
        Edge old_edge=deleteE(g, loc, f);
        Edge new_edge=addE(g, new_loc, f);
        T::addE(mapping, old_edge, new_edge);
    }    
    Vertex vertex=g[n].v();
    return OneExtraReturnValue<Vertex, T>::ret(vertex, mapping);
}


//this template "almost" works for EdgeLabeling<Vertex>
template<template<typename> class C, typename T>
std::ostream& operator <<(std::ostream& os, const C<T>& obj)
{
    for (auto it=obj.cbegin(); it!=obj.cend();it++) {
        T e1=it->first; //If I want to do something with T I may need template template
        T e2=it->second; //But normally, C vould have a nested type, e.g. C::value_type
        os << e1.to_int()<< "->" << e2.to_int()<< "\n";
    }
    return os;
}

//this seems beter but, it causes ambigious overloads
//could probably be salvaged with some concepts
/*template<typename T>
std::ostream& operator <<(std::ostream& os, const T &obj)
{
    for (auto it=obj.cbegin(); it!=obj.cend();it++) {
        os << it->first.to_int()<< "->" << it->second.to_int()<< "\n";
    }
    return os;
}
*/


int main() {
    Graph g;
    addMultipleV(g, 10);
    for(int i=0; i<10; i++)
        addE(g, Location(i,(i+1)%10));    

    ends_to_new_vertex(g, {Location(0,1), Location(3,4)});

    Edge removed1=g.find(Location(5,6))->e();
    Edge removed2=g.find(Location(7,8))->e();
    Edge removed3=g.find(Location(9,8))->e();

    auto mapping=ends_to_new_vertex<EdgeMapper>(g, 
            {Location(5,6), Location(7,8), Location(9,8)});

    std::cout<<"The new vertex has hopefully id "<<g[11].v().to_int()<<".\n";

    Edge added1=g.find(Location(5,11))->e();
    Edge added2=g.find(Location(7,11))->e();
    Edge added3=g.find(Location(9,11))->e();

    std::cout<<"We replaced edges "
             <<removed1.to_int()<<", "<<removed2.to_int()<<", "<<removed3.to_int()
             <<" with "<<added1.to_int()<<", "<<added2.to_int()<<", "<<added3.to_int()
             <<", respectively.\n";
    
    for(auto p: mapping.second) 
        std::cout<<"Mapper says that we replaced edge "<<p.first.to_int()<<" with "<<p.second.to_int()<<"\n";
    std::cout<<"Mapper does not know about other changes.\n";

    std::cout<<mapping.second;
    
    
    
    //btw ... find functions are crazy 
/*
For this section, the relevant ba_graph files are
/include/impl/basic/classes.h
/include/impl/basic/rotation_predicates.hpp
/include/impl/basic/incidence_predicates.hpp
/include/impl/basic/helpers.hpp
/include/impl/basic/graph.h
/include/impl/basic/graph.cpp
*/
    g.find(added1.v1(),added1);
    g.find(RP::degree(3), Number(9));
     
}
