#include <vector>
#include <iostream>
#include <utility>

/*
This example usses ba_graph libraty available at
https://bitbucket.org/relatko/ba-graph/
You just need the include folder. To compile this use
$(CXX) -std=c++17 -fconcepts -I <include folder name> example5.cpp -o a.out
You need g++ version >8.0.0.
*/
#include <impl/basic/include.hpp>


using namespace ba_graph;

Graph create1(Factory &f=static_factory) {
    Graph G;
    addV(G,f);
    return std::move(G);
}

//you can also create a function that modifies only a newly created graph
Graph create2(Graph &&G, Factory &f=static_factory) {
    addV(G,f);
    return std::move(G);
}


class JustMovable {
    int *a;
public:
    JustMovable() {a= new int[100];}    
    ~JustMovable() {delete [] a;}    

    JustMovable(const JustMovable &)= delete;
    JustMovable & operator= (const JustMovable &)= delete;
    
    friend void swap(JustMovable& first, JustMovable& second) noexcept
    {
        std::swap(first.a, second.a);        
    }
    
    JustMovable(JustMovable &&other) noexcept {
        a=new int [1];
        swap(*this, other);
    }
    JustMovable& operator= (JustMovable &&other) noexcept {
        swap(*this, other);
        return *this;
    }
    
};


int main() {
    Graph G(create2(create1())); // no copying!!!
    
        
    Graph H2;
    std::swap(G, H2);

    JustMovable a;
    
    a=JustMovable();

    
//OK, some find maddness
/*
For this section, the relevant ba_graph files are
/include/impl/basic/classes.h
/include/impl/basic/rotation_predicates.hpp
/include/impl/basic/incidence_predicates.hpp
/include/impl/basic/helpers.hpp
/include/impl/basic/graph.h
/include/impl/basic/graph.cpp
*/
    Graph H;
    for(int i=0;i<5;i++) addV(H,Number(i));
    for(int i=0;i<5;i++) addE(H,Location(i, (i+1)%5));
    addE(H,Location(0,3));
    addE(H,Location(2,2));
    auto counter=IP::count();
    H.list(RP::all(), !IP::loop());
    H.list(RP::all(), counter);
    H.list(RP::all(), !IP::loop() && counter);
    
    std::cout << counter.get_count();
    
}
