#include <vector>
#include <iostream>
#include <impl/basic/include.hpp>
#include <utility>


using namespace ba_graph;

Graph create1(Factory &f=static_factory) {
    Graph G;
    addV(G,f);
    return std::move(G);
}

//you can also create a function that modifies only a newly created graph
Graph create2(Graph &&G, Factory &f=static_factory) {
    addV(G,f);
    return std::move(G);
}


class JustMovable {
    int *a;
public:
    JustMovable() {a= new int[100];}    
    ~JustMovable() {delete [] a;}    

    JustMovable(const JustMovable &)= delete;
    JustMovable & operator= (const JustMovable &)= delete;
    
    friend void swap(JustMovable& first, JustMovable& second) noexcept
    {
        std::swap(first.a, second.a);        
    }
    
    JustMovable(JustMovable &&other) noexcept {
        a=new int [1];
        swap(*this, other);
    }
    JustMovable& operator= (JustMovable &&other) noexcept {
        swap(*this, other);
        return *this;
    }
    
};


int main() {
    Graph G(create2(create1())); // no copying!!!
    
//    Graph H(G); //copying is not possible even by accident

    JustMovable a;
    
    a=JustMovable();
    
//OK, some find maddness
    Graph H;
    for(int i=0;i<5;i++) addV(H,Number(i));
    for(int i=0;i<5;i++) addE(H,Location(i, (i+1)%5));
    addE(H,Location(0,3));
    addE(H,Location(2,2));
    auto counter=IP::count();
    H.list(RP::all(), !IP::loop() && counter);
    
    std::cout << counter.get_count();
    
}
