#include <iostream>
#include <vector>
#include <memory>

/*
This sketches how to get rid of the omnipresent std::make_shared
This example does not work as a different way of handling NULL pointers would be necessary
For working example see example7start.cpp
*/

class ImmutablePair {
    typedef std::pair<ImmutablePair, ImmutablePair> ipp;
    std::shared_ptr<ipp> p_;
    int value_;
public:
    ImmutablePair(): value_(0) {};
    ImmutablePair(ImmutablePair p1, ImmutablePair p2,
                  int value): p_(std::make_shared<ipp>(p1,p2)), value_(value) {}

    auto get_p1() const {return p->first;}    
    auto get_p2() const {return p->second;}    
    int get_value() const {return value_;}
};


auto last=ImmutablePair();
auto root=ImmutablePair();

auto change_helper(ImmutablePair p,
        const std::vector<int> &where, int value) {
    if (where.size()==0) 
        return ImmutablePair(p->get_p1(),p->get_p2(),value);

    if (where[0]==-1) {
        ImmutablePair ip;
        if (p->get_p1()) ip=p->get_p1();
        else ip=ImmutablePair();
        auto where2=where;
        where2.erase(where2.begin()); //super inefficient
        return ImmutablePair
            (change_helper(ip,where2,value),p->get_p2(),p->get_value());
    }

    if (where[0]==1) {
        ImmutablePair ip;
        if (p->get_p2()) ip=p->get_p2();
        else ip=std::make_shared<ImmutablePair>();
        auto where2=where;
        where2.erase(where2.begin()); //super inefficient
        return std::make_shared<ImmutablePair>
            (p->get_p1(), change_helper(ip,where2,value),p->get_value());
    }

    return std::shared_ptr<ImmutablePair>();
}

void change(const std::vector<int> where, int value) {
    auto a=change_helper(root, where, value);
    last=root;
    root=a;
}


int main() {
   change({},4);
    
   change({1, -1, 1}, 4);
   change({1, -1, -1}, 5);
   change({1, -1, 1}, 6);
   
   std::cout<<root->get_p2()->get_p1()->get_p2()->get_value();
   std::cout<<last->get_p2()->get_p1()->get_p2()->get_value();
}
