#include <iostream>
#include <vector>
#include <memory>

class ImmutablePair {
    std::shared_ptr<ImmutablePair> p1_;
    std::shared_ptr<ImmutablePair> p2_;
    int value_;
public:
    ImmutablePair(): value_(0) {};
    ImmutablePair(std::shared_ptr<ImmutablePair> p1, 
                  std::shared_ptr<ImmutablePair> p2,
                  int value): p1_(p1), p2_(p2), value_(value) {}

    auto get_p1() const {return p1_;}    
    auto get_p2() const {return p2_;}    
    int get_value() const {return value_;}
};


auto last=std::make_shared<ImmutablePair>();
auto root=std::make_shared<ImmutablePair>();

auto change_helper(std::shared_ptr<ImmutablePair> p,
        const std::vector<int> &where, int value) {
    if (where.size()==0) 
        return std::make_shared<ImmutablePair>
            (p->get_p1(),p->get_p2(),value);

    if (where[0]==-1) {
        std::shared_ptr<ImmutablePair> ip;
        if (p->get_p1()) ip=p->get_p1();
        else ip=std::make_shared<ImmutablePair>();
        auto where2=where;
        where2.erase(where2.begin()); //super inefficient
        return std::make_shared<ImmutablePair>
            (change_helper(ip,where2,value),p->get_p2(),p->get_value());
    }

    if (where[0]==1) {
        std::shared_ptr<ImmutablePair> ip;
        if (p->get_p2()) ip=p->get_p2();
        else ip=std::make_shared<ImmutablePair>();
        auto where2=where;
        where2.erase(where2.begin()); //super inefficient
        return std::make_shared<ImmutablePair>
            (p->get_p1(), change_helper(ip,where2,value),p->get_value());
    }

    return std::shared_ptr<ImmutablePair>();
}

void change(const std::vector<int> where, int value) {
    auto a=change_helper(root, where, value);
    last=root;
    root=a;
}


int main() {
   change({},4);
    
   change({1, -1, 1}, 4);
   change({1, -1, -1}, 5);
   change({1, -1, 1}, 6);
   
   std::cout<<root->get_p2()->get_p1()->get_p2()->get_value();
   std::cout<<last->get_p2()->get_p1()->get_p2()->get_value();
}
