#include <vector>
#include <string>
#include <iostream>
#include <algorithm>
#include <map>

class Match {
public: 
    std::string team1;
    std::string team2;
    int goals1;
    int goals2;
    Match(std::string team1_, std::string team2_, int goals1_, int goals2_):
            team1(team1_), team2(team2_), goals1(goals1_), goals2(goals2_) {};
};

class FifaRanking {
public:
    get_rank(std::string team) {
        if (team=="Germany") return 1;
        if (team=="France") return 3;
        if (team=="Slovakia") return 30;
        if (team=="San Marino") return -200;
        return 201;
    }
};


class FifaRankingRule {
    FifaRanking ranking;
public:
    void rank(std::vector<std::string>::iterator begin, 
             std::vector<std::string>::iterator end,
             std::vector<Match>) {
         std::stable_sort(begin,end, 
            [=](const std::string & a, const std::string & b) -> bool
            { 
                return ranking.get_rank(a) < ranking.get_rank(b); 
            }
            );
    }
};


class PointsRule {
    FifaRanking ranking;
public:
    int score_to_points(int goals1, int goals2) {
        if (goals1>goals2) return 3;
        if (goals1<goals2) return 0;
        return 1;
    }
    
    void rank(std::vector<std::string>::iterator begin, 
             std::vector<std::string>::iterator end,
             std::vector<Match> matches) {
         std::map<std::string, int> points;
         
         for (auto it=begin;it!=end;it++) points[*it]=0;
         for (auto m: matches) {
             auto team1_it=points.find(m.team1);
             auto team2_it=points.find(m.team2);
             if (team1_it!=points.end()) 
                 team1_it->second+=score_to_points(m.goals1,m.goals2);
             if (team2_it!=points.end()) 
                 team2_it->second+=score_to_points(m.goals2,m.goals1);
         }
         
         std::stable_sort(begin,end, 
            [=](const std::string & a, const std::string & b) -> bool
            { 
                return points.at(a) > points.at(b); 
            }
            );
    }
};


//todo
//goal difference rule + more goals scored rule ... 
     //extract repeated code for accumulating results
//put two rules togerher
//recursive rule

int main() {
    std::vector<std::string> teams;
    std::vector<Match> matches;
    
    teams.emplace_back("Germany");
    teams.emplace_back("France");
    teams.emplace_back("Slovakia");
    teams.emplace_back("San Marino");

    matches.emplace_back("Germany", "France", 1, 1);
    matches.emplace_back("Slovakia", "France", 2, 2);
    matches.emplace_back("Germany", "Slovakia", 1, 1);
    matches.emplace_back("San Marino", "France", 0, 5);
    matches.emplace_back("Slovakia", "San Marino", 7, 0);
    matches.emplace_back("Germany", "San Marino", 6, 0);
    
    
    FifaRankingRule().rank(teams.begin(),teams.end(), matches);
    PointsRule().rank(teams.begin(),teams.end(), matches);

    for (auto team: teams) std::cout<< team <<"\n";    
}