#include <vector>
#include <string>
#include <iostream>
#include <algorithm>
#include <concepts>

class Person {
public: 
    std::string name;
    std::string country;    
    Person(std::string name_, std::string country_): name(name_), country(country_) {}
};

class person_has_country {
    std::string country_;
    public:
    person_has_country(std::string country) : country_(country) {};
    bool operator() (const Person &p) {
        return p.country==country_;
    }        
};

class person_has_name {
    std::string name_;
    public:
    person_has_name(std::string name) : name_(name) {};
    bool operator() (const Person &p) {
        return p.name==name_;
    }        
};

template<typename T>
concept PersonPredicate = requires (T pred, const Person &p) {
    {pred(p)} -> std::convertible_to<bool>;
};

template<PersonPredicate T, PersonPredicate U> 
class PredicateAnd {
    T p1_;
    U p2_;
public:
    PredicateAnd(const T &p1, const U &p2): p1_(p1), p2_(p2) {}
    bool operator() (const Person &p) {
        return p1_(p) && p2_(p);
    }
};

template<PersonPredicate T, PersonPredicate U> 
auto operator && (const T& p1, const U& p2) {return PredicateAnd(p1,p2);}


int main() {
    std::vector<Person> people;
    people.emplace_back("Jan", "Slovakia");
    people.emplace_back("Jan", "Czechia");
    people.emplace_back("Jan", "Netherlands");
    people.emplace_back("Jana", "Slovakia");
    
    auto it_dutch=std::find_if(people.begin(),people.end(), person_has_country("Netherlands") && person_has_name("Jan"));
    
    if (it_dutch==people.end())
        std::cout<<"We have no Dutch Jan here.\n";
    else
        std::cout<<"I found a Dutch Jan.\n";

}
