import unittest
from unittest.mock import Mock

from src.hra import Hra


class TestHra(unittest.TestCase):
    def setUp(self):
        self.plocha = Mock()
        self.koniec = Mock()
        self.hra = Hra(1, 1, self.plocha, self.koniec)

    def test_pridaj_hraca(self):
        self.assertEqual((self.hra.hrac1,self.hra.hrac2), (0, 0))
        res = self.hra.pridaj_hraca(2)
        self.assertTrue(res)
        self.assertEqual((self.hra.hrac1,self.hra.hrac2), (2, 0))
        res = self.hra.pridaj_hraca(2)
        self.assertFalse(res)
        self.assertEqual((self.hra.hrac1,self.hra.hrac2), (2, 0))
        res = self.hra.pridaj_hraca(1)
        self.assertTrue(res)
        self.assertEqual((self.hra.hrac1,self.hra.hrac2), (2, 1))
        res = self.hra.pridaj_hraca(1)
        self.assertFalse(res)
        self.assertEqual((self.hra.hrac1,self.hra.hrac2), (2, 1))

    def test_tah(self):
        self.koniec.return_value = "OK"
        self.plocha.pohni_figurkou.return_value = None #tah bude zly
        self.plocha.na_tahu = "W"
        self.hra.pridaj_hraca(1)
        self.hra.pridaj_hraca(2)
        self.assertIs(self.hra.plocha, self.plocha)
        self.assertEqual(self.hra.tah(3, (0, 0), (0, 0)), "NieJeNaTahu")
        self.assertEqual(self.hra.tah(2, (0, 0), (0, 0)), "NieJeNaTahu")
        self.assertIs(self.hra.plocha, self.plocha)
        self.assertEqual(self.hra.tah(1, (0, 0), (0, 0)), "ZlyTah")
        self.assertIs(self.hra.plocha, self.plocha)
        # vytvorime novu namockovanu plochu
        plocha2 = Mock()
        plocha2.na_tahu = "B"
        self.plocha.pohni_figurkou.return_value = plocha2 #tah bude dobry
        # teraz uz je tah dobry        
        self.assertEqual(self.hra.tah(1, (0, 0), (0, 0)), "OK")
        self.assertIs(self.hra.plocha, plocha2)
        # Dalsi tah
        plocha2.pohni_figurkou.return_value = None #tah bude zly
        self.koniec.return_value = "Win"
        self.assertEqual(self.hra.tah(1, (0, 0), (0, 0)), "NieJeNaTahu")
        self.assertEqual(self.hra.tah(2, (0, 0), (0, 0)), "ZlyTah")
        self.assertIs(self.hra.plocha, plocha2)
        plocha2.pohni_figurkou.return_value = self.plocha #tah bude dobry
        self.assertEqual(self.hra.tah(2, (0, 0), (0, 0)), "Win")
        self.assertIs(self.hra.plocha, self.plocha)

        

if __name__ == '__main__':
    unittest.main()

