#include <iostream>

//A simple class
struct Class1 {
private:
	int a;
public:
	constexpr Class1() = default; //default constructor
	constexpr Class1(int a_): a(a_) {}; //a very reasonable constructor 
	//constexpr! There is also consteval...

	~Class1() = default; //default destructor
	constexpr Class1(const Class1&) = default; //default copy constructor
	constexpr Class1& operator=(const Class1&) = default; //default copy assignment
	//You do not even need to write this ... it is very default. 
	//If you do not want this, use delete
	//Check out "Rule of 3"

	explicit operator int() const {return a;}; 
	//You should care for consts in all languages
	//Check how explicit conversion works.

	auto operator<=>(const Class1&) const = default; 
	//You have to write this, this is not default
	//atomic operation
	//auto !!! It is std::strong_ordering 
};

constexpr Class1 operator""_c1(unsigned long long arg) {
	return Class1(arg);
}

int main() {
	Class1 a(10); //reasonable constructor
	Class1 b; //default constructor
	b = a; // copy assibnment
	Class1 c(b); //copy constructor

	auto d = 12_c1; //120_km, 3+2i

	std::cout<<(int)a<<" "<<(int)b<<" "<<(int)c<<" "<<(int) d<<"\n";

	std::cout<<(Class1(5) < Class1(10))<<" "
	         <<(Class1(5) == Class1(10))<<" "
			 <<(Class1(5) != Class1(10))<<"\n";

	return 0;
}
