#include <iostream>
#include <vector>
#include <type_traits>

//We will discuss C++ reference types as a solution to avoid coing too many copies.


//A simple class
class Class1 {
private:
	std::vector<int> a;
public:
	Class1() = default; //default constructor
	Class1(int a_): a({a_}) {}; //our not so reasonable constructor 

	~Class1() = default; //default destructor
	Class1(Class1&&) = default; //move constructor
	Class1& operator=(Class1&&) = default; //move assignment
	//this by default deletes copy constructor and copy assignment

	operator int() const {return a.size();}; //a silly default conversion
	Class1 operator*(int other) {return a.size() ? Class1(a[0]*other): Class1();}
};

//If we want to make us
int function_consuming_class1(Class1 &&a){
	return a;
}



//forwarding reference
template<typename T> requires std::is_same_v<Class1, typename std::remove_reference<T>::type>
T just_print_and_dont_touch(T&& t) { //either lvalue or rvalue referrence
	std::cout<<"Ja iba tlaciiim:"<<t<<"\n";
    return std::forward<T>(t);
}

void i_want_lvalue_reference(Class1 &) {
    return;
}

void i_want_rvalue_reference(Class1 &&) {
    return;
}

void i_want_const_lvalue_reference(const Class1 &) {
    return;
}

int main() {
    Class1 a; //default constructor
	Class1 b(10); //our constructor
	Class1 c(std::move(b)); //move constructor, do not use c further
	Class1 d;
//	d=c; //this fails, no copy assignent
	d = std::move(c);
	Class1 e = d*2;

	std::cout<<a<<" "<<d<<"\n";

	int x = function_consuming_class1(Class1()); //the consuming function can consume auxiliary value
	int y = function_consuming_class1(std::move(d)); //but also ordinary variable if it should not be used anymore
	//we should not use d from now on

	std::cout<<x<<" "<<y<<"\n";

	i_want_lvalue_reference(just_print_and_dont_touch(a)); //no std::move so lvalue reference
	i_want_rvalue_reference(just_print_and_dont_touch(Class1(15))); //rvalue reference

	i_want_const_lvalue_reference(just_print_and_dont_touch(a)); 
	i_want_const_lvalue_reference(just_print_and_dont_touch(Class1(15)));
}
