i=0
#function can return functions
def get_function():
  def function_to_return():
    global i
    i+=1
    return i
  return function_to_return

f=get_function()
f()
f()
#i is just a global variable
i



#lets initialize the counter
def get_function(init):
  j=init
  def function_to_return():
    nonlocal j
    j+=1
    return j
  return function_to_return

f = get_function(2)
f()
f()

g = get_function(2)
f()
g()
f()
g()
#The "local" variable lives after finishing the function




#decorators are... something that modifies something else. So you may decorate a function, such decorator takes a function and returns a function.
#note the variable arguments
def incremented(f):
  def inc(*arg, **kwarg):
    return f(*arg, **kwarg)+1
  return inc

@incremented
@incremented
def nice_function():
  return 5;

nice_function()


#btw variable arguments
def multiply(a, *args):
  z = a
  for num in args:
    z *= num
  print(z)

multiply(2)
multiply(2, 6, 8)

def divide(a, b, times_done=1):
  for i in range(times_done):
    a=a/b
  return a

divide(2, 2)
divide(2, 2, 2)
divide(2, 2, times_done=2)

#without **kwargs
def incremented(f):
  def inc(*args):
    return f(*args)+1
  return inc

@incremented
def divide(a, b, times_done=1):
  for i in range(times_done):
    a=a/b
  return a

divide(2, 2)
divide(2, 2, 2)
divide(2, 2, times_done=2) #this fails


#what is going on?
def watched(f):
  def inc(*arg, **kwarg):
    print(arg)
    print(kwarg)
    return f(*arg, **kwarg)
  return inc

@watched
def divide(a, b, times_done=1, add=0):
  for i in range(times_done):
    a=a/b
  return a+add
  
  

divide(2, 2)
divide(2, 2, 2)
divide(2, 2, times_done=1)
divide(2, 2, add=1)
  

#Exercise1
#Write a decorator that takes a function and converts its first argument from miles to km

#Exercise2
#As in exercise 1 but you get the index of the argument that should be converted

#Exercise3
#Write a decorator that takes a class which has some method with name "secret"
#And modifies it in such that to perform a call of the method you must add "42" as the first argument,
#that is instead of a.secret("x", 32) you have to call a.secret(42, "x", 32)



  
