##General comments

In this homework you had to deal with several issues.

* How to separate logging
* How to separate Reservation class to allow solitary unittest
* How to separate the printing of the logs 
* How to make tests readable and sufficient
* How to mock the Reservation class (and factory) for solitary Library test
* What about the complex reserve_book method

Note that the code I gave to you was written in a standard "lazy" way. Thus I run some tests by hand and when I concluded that it "somehow" works I gave the results to you. Of course that the code obtained in this way contains errors (and I was OK with that). Hopefully you have found some of them writing the tests :). In the solution I give you the errors I found are corrected. The test coverage is reasonable (at least for non-logging versions of the classes, and maybe except for the complex reserve_book method) and there should not be too many errors left in the Reservation and Library classes.


###How to separate logging

Logging is not a concern that you typically separate, but you should be able to separate whatever you want. Thus for sake of this exercise, I decided to ask you to separate logging (the main reason is that this is easy to explain).

You create two classes. There are two basic approaches to put them together: composition and inheritance. In my solution I use inheritance to extend the Reservation and Library classes to classes with logging (it is not that different to do this with composition, instead of `super().` you save a library, lets say as, `self.lib` and use `self.lib`). Inheritance is typically an inferior choice, but in this case the Liskov substitution principle is satisfied, thus I chose this easier approach.

Second solution involves strategy pattern. Your Library gets an object that contains logging functions and uses them instead of creating strings on its own.

Third solution (there may be more sensible approaches) is based on template pattern. Library defines empty logging functions and these functions are defined in Logging subclass of Library.

Second and third solution have one small disadvantage. There remains some traces of logging in the Library class. In the first solution we need somehow obtain the information on the failure reason in some methods.

All these comments apply also for Reservation class.


###How to separate Reservation class to allow solitary unittest

Library class constructs instances of Reservation class. Those classes are coupled and we cannot really test them like this in a solitary manner. There are two solutions.

* Inject Reservation factory in the constructor
* In reserve_book we give a Reservation object (or a Reservation factory, but this is unnecessarily complex as only one Reservation is created) as an argument. If we provide a Reservation object it makes sense to add getters/properties to Reservation class and remove the arguments that can be obtained from the Reservation instance.

Note that the fact that Library creates Reservations obstructs some approaches to separate logging---you want that Library constructs Reservation objects with logging and not pure Reservation objects. 


###How to separate the printing of the logs 

There are more approaches, but by far the easiest one is to inject printing function into logging objects.


###How to make tests readable and sufficient

Some random comments:

* Use public interface for testing whenever possible (almost always)
* Your test should contain boundary values
* You do not test constructor except when they should have some side-effect. In this case it is reasonable to add a check if in Reservation from_<= to
* If the input contains more errors, it is probably not important which error is returned. You test should allow for both errors
* If there is more than one reasonable result of an action (e.g. change reservation owner when there are two valid reservations) allow each of the choices
* The setUp should be reasonable. That is, one can memorize it whenever possible.
* If you have problem writing your tests, the design is probably not that good, change it. Here, an obvious issue is that we do not know how many copies of a book are in Library, and it is good idea to add a method to find this out. In my solution I decided to do it the hard (and maybe not the correct) way and I tested this functionality using the tools available.


###How to mock the Reservation class for solitary Library test

This was indeed harder then I expected. The design of the classes is not that good and they are tightly coupled. However, there is no significant technical problem. Only problem is that this implies that the solitary tests are a bit more complex and harder to read (and unfortunately, maybe, to some degree implementation dependent, but I tried to make this dependence as small as possible).

In my solution I used Python mocking Library. I want to stress that the use of the mocking library does not make that much of a difference until you start to spy how the Mocked object's methods were called. I do not use this that much. Thus it is quite easy to rewrite my test by writing the mock classes by hand. 

### What about the complex reserve_book method

You should ask yourself why is the reserve_book method so complex. There are good reasons to it and it should be captured in the tests (I captured it at least to a degree).

