## Dizajn systému

Systém je naprogramovaný v jave, takže dizajn sa snaží byť objektovo orientovaný.

### Reprezentácia high-level štruktúry turnaja

Za najväčšiu dizajnovú výzvu som považoval členitú a nepravidelnú štruktúru turnaja.
Jej high-level reprezentáciu staviam na sieti objektov dvoch tried:

* `Group`      --  Objekty tejto triedy reprezentujú logicky oddelenú časť turnaja, do ktorej vojde
                   niekoľko tímov a nejakým procesom sa im určí nejaké poradie (význam
                   tohto poradia sa môže líšiť).
                   
                   Trieda `Group` je teda určená na to, aby reprezentovala napríklad:
                   
                   *  Skupinu hrajúcu systémom každý s každým (takéto skupiny sa vo FIFA
                      turnajoch vyskytujú často).
                   *  Jedno kolo playoff.
                   *  Jeden losovací kôš.
                   *  Poradie tímov, ktoré sa v základnej skupine umiestnili ako druhé
                      (v takejto skupine možno bude počas kvalifikácie aj Slovensko).
                    
                   Pri každej `Group`-e by teda malo od začiatku turnaja byť jasné, koľko tímov
                   v nej bude, aké sa v nej odohrajú zápasy a akým spôsobom sa určí poradie.
                   Nemusí však byť jasné, aké presne tímy v nej budú.

* `SlotFiller` --  Každý objekt tejto triedy popisuje jeden tím, nemusí ho však popisovať
                   explicitne. Význam jedného `SlotFillera` teda môže byť napríklad:
                   
                   * "Argentína"
                   * "Víťaz skupiny C"
                   * "Tím, ktorý prehrá v prvom semifinále"
                   
                   O každom SlotFilleri by malo platiť, že v nejakom momente turnaja ho bude
                   už možné vyhodnotiť, teda určiť konkrétny tím, ktorý mu zodpovedá.
                   Úlohou `SlotFillera` je vypĺňať slot v `Groupe`.
                   Hoci teda na začiatku turnaja nevieme, aké tímy sa dostanú do jednotlivých
                   skupín, už od začiatku turnaja by sme mali presne vedieť, aké SlotFillery
                   sa ich zúčastnia.
                   
                   To, aké SlotFillery vstupujú do jednotlivých `Group` nám vlastne určuje
                   high-level štruktúru turnaja.

#### Interakcia Group a SlotFillerov

Interakciu medzi Groupami a SlotFillermi implementujem pomocou návrhového vzoru observer.

Každá Group si od začiatku pamätá, aké SlotFillery do nej vstúpia. S týmito SlotFillermi je potom
vo vzťahu observer-subject -- vždy keď nejaký jej SlotFiller zistí svoju explicitnú hodnotu, dá o
tom vedieť Groupe. Keď sa Groupe vyhodnotia všetky SlotFillery, môže sa táto časť turnaja začať.

Aj niektoré SlotFillery môžu byť observery: typický príklad je SlotFiller typu "tím, ktorý v Groupe
G skončí i-ty ". Takýto SlotFiller pozoruje Groupu G a keď daná Group skončí, dá mu vedieť, aby sa
mohol vyhodnotiť.

Triedy Group aj SlotFiller sú určené na to, aby sa z nich dedilo.

### Reprezentácia low-level štruktúry

Poradie týmov v jednej Groupe sa typicky určuje zápasmi medzi nimi. Každý zápas si reprezentujem
ako jeden objekt triedy `Match`, vlastnený Groupou, v ktorej sa odohráva. Objekt typu Match si
pamätá tímy (resp. SlotFillery) hrajúce daný zápas, dátum a čas zápasu, či už bol odohraný
a prípadný výsledok zápasu. Trieda Match má metódu `playMatch(int, int)`, ktorou je zápasu možné
povedať, že sa práve odohral a ako dopadol.

Všetky Groupy, SlotFillery aj Matche sa skonštruujú už pri inicializácii programu, Matche sú teda
všetky neodohrané. Match a Group spolu interagujú pomocou vzoru observer: keď sa Match odohrá, informuje
o tom svoju Group. Keď sa v Group odohrajú všetky Matche, Group vie, že už skončila (a teda jej poradie
je finálne). Práve skončená Group o tom informuje prípadných SlotFillerov, ktorí ju pozorujú.

#### Tiebreaky

Poradie v skupine, kde sa hrali nejaké zápasy, sa typicky určuje podľa sady kritérií ako počet bodov
(v systéme výhra-3, remíza-1, prehra-0), počet strelených gólov, vzájomný zápas atď. Každé takéto kritérium
volám tiebreak a v každej Groupe používajúcej tiebreaky je pre každý tiebreak jeden objekt typu TieBreak.

Interakcia je nasledovná: Group dá raz začas TieBreaku zoznam svojich zápasov, tímov a dôležitejších
tiebreakov (tie sú potrebné pre tiebreaky typu "vzájomný zápas s týmom, ktorý je inak na rovnakom mieste"). 
TieBreak to nejako spracuje (napríklad spočíta, koľko bodov jednotlivé tímy získali v odohraných zápasoch)
a následne je ochotný porovnávať dvojice tímov (hovoriť, ktorý z nich je lepší). Po skončení skupiny sa 
tímy utriedia pomocou takýchto porovnaní.

### Interakcia turnaja so svetom

Takto reprezentovanú štruktúru zostrojíme pri inicializácii systému. Ďalej sa s ňou dá interagovať dvoma
spôsobmi:

*  Požiadame nejakú Group, aby vypísala niečo o sebe (priebežné výsledky, prípadne zoznam zápasov) -- v takom
   prípade sa v štruktúrach nič nebude meniť, iba daná Group vypíše požadovanú informáciu.
*  Povieme niektorému Match, že sa už odohral. Potom už nemusíme robiť nič ďalšie, všetko sa o seba postará samo:
   *  Group, z ktorej je daný Match, si to všimne a prepočíta si svoje priebežné výsledky.
   *  Ak to bol posledný zápas v nejakej Group, táto skončí a informuje o tom prípadných SlotFillerov, ktorí na ňu
      čakajú.
   *  Títo SlotFilleri sa vyhodnotia a informujú o tom Groupy čakajúce na ne (ktoré vďaka tomu možno budú môcť začať)
   *  ...

### Štruktúra programu

Jednotlivé Groupy v sebe drží jediný objekt triedy GroupManager (ktorá používa návrhový vzor singleton). Tento objekt
na začiatku celú štruktúru turnaja načíta zo súboru. Okrem toho si pamätá priradenie IDčiek Groupám a umožňuje ostatným 
hľadať Groupy podľa ID (to sa hodí pri načítaní štruktúry turnaja). Požiadavky na výpis poradia prípadne zoznamu zápasov
idú tiež cez GroupManager.

O kalendár sa stará ďalší singleton DateManager, ktorý si pre jednotlivé dátumy pamätá zoznam zápasov, ktoré sa v nich
majú odohrať. Každý Match sa pri svojom vzniku zaregistruje v DateManageri. DateManager potom umožňuje odsimulovať jeden
deň -- jednoducho odsimuluje odohrané zápasy a oznámi im ich výsledok.

### Interfacy FIFA World Ranking a Simulátor zápasov

Od FIFA World Rankingu by som chcel aby podporoval dve funkcie

* Povedz mi, ktorý tým je na danom mieste v rebríčku
* Povedz mi, na ktorom mieste v rebríčku je daný tím

Tomu zodpovedá aj stub implementácia v singleton triede StaticRanking.

Od MatchSimulatora chcem iba jednu funkciu:

* Odsimuluj daný zápas (a povedz mi výsledok)

Tomu zodpovedá stub implementácia v singleton triede SimpleMatchSimulator.
