## Formáty textových súborov

Systém pre svoju funkciu potrebuje dva textové súbory.

Prvý z nich obsahuje svetový rebríček tímov a používa ho
naša stub verzia FIFA World Ranking systému. Tento súbor
sa musí volať ranking.txt a odporúčam ho nemeniť.

Druhý súbor popisuje "tvar" turnaja -- typy a veľkosti
jednotlivých skupín a kôl a pravidlá postupu. Ak programu
nepoviete inak, defaultne ho bude hľadať pod názvom groups.txt.

### Formát súboru so svetovým rebríčkom (ranking.txt)

Súbor začína počtom tímov v rebríčku. Nasleduje ich zoznam
(v poradí podľa rebríčka). Každý tým je charakterizovaný
jedným riadkom. Na začiatku riadku je skratka daného tímu
(napr. SVK), nasleduje dlhý názov týmu.

### Formát súboru s tvarom turnaja (default: groups.txt)

Súbor začína jedným číslom: počtom skupín.
Nasledujú popisy týchto skupín.

#### Popis jednej skupiny

Popis skupiny začína jej IDčkom -- jedným reťazcovým tokenom.
Nasleduje **typ** skupiny. Ďalej nasleduje počet slotov v skupine 
(počet tímov, ktoré ju budú hrať). Potom nasleduje pre každý slot 
v danej skupine jeho popis (viac v časti *Popis jedného slotu* ).
Nasleduje zvyšok popisu špecifický pre daný typ. 

Implementované typy sú nasledovné:

* RoundRobin -- každý s každým
* RandomDrawing -- bez zápasov, náhodne sa určí poradie
* OldResult -- bez zápasov, poradie podľa výsledkov z predošlých skupín

##### RoundRobin

RoundRobin je skupina typu "každý s každým". Jej špecifická časť popisu
vyzerá nasledovne:

Na začiatku je počet tiebreakov. Nasledujú popisy jednotlivých tiebreakov
(viac v časti *Popis tiebreaku* ).

Popis končí popisom plánovača zápasu (viac v časti *Popis plánovača* ).

##### RandomDrawing

V tomto druhu skupiny sa nehrajú žiadne zápasy, vstupné tímy sa iba náhodne
zamiešajú. Slúži na implementáciu losovacích košov. Špecifická časť popisu je
prázdna.

##### OldResult

Ani v tomto druhu skupiny sa nehrajú zápasy, tímy sa zoradia podľa svojich
výsledkov v skupinách z minulosti. Týmto sa implementujú kritériá typu "dva
najlepšie z týmov, ktoré v základnej skupine skončili druhé". Špecifická časť
popisu začína počtom skupín, ktorých zápasy máme v našej skupine zohľadňovať.
Nasleduje zoznam ich IDčiek.
Popis ďalej pokačuje počtom tiebreakov, ktoré máme brať do úvahy a následne ich
popismi.

#### Popis jedného slotu

Popis slotu začína jeho typom, nasledujú údaje špecifické pre daný typ.
Implementované typy sú nasledovné:

* FifaRanked -- podľa rebríčka FIFA
* PlacedIth -- podľa výsledku v inej skupine

##### FifaRanked

Takto sú označované sloty, ktoré sa na začiatku turnaja vyplnia podľa poradia
FIFA World Ranking. Špecifickú časť popisu tvorí jedno číslo: poradie týmu
vo FIFA World Ranking.

##### PlacedIth

Do takéhoto slotu postúpi tým, ktorý sa umiestni na konkrétnom mieste v nejakej
inej skupine. Špecifický tvorí jedno číslo a jeden reťazec: daná pozícia a
IDčko danej skupiny.

#### Popis tiebreaku

Popis tiebreaku začína jeho typom, potenciálne môžu nasledovať nejaké špecifické
údaje. Implementované typy sú nasledovné:

* Points -- Štandardné body (výhra -- 3, remíza -- 1, prehra -- 0).
* GoalsDifference -- Rozdiel medzi strelenými a inkasovanými gólmi.

Žiaden z dosiaľ implementovaných tiebreakov nepotrebuje ďalšie špecifické údaje.

#### Popis plánovače

Popis plánovača začína jeho typom, nasledujú špecifické dáta. Implementované typy:

* AtDates -- explicitne vymenovené dátumy
* Weekly -- každý týždeň, počnúc daným dátumom

##### AtDates

Tento plánovač zodpovedá pevne daným termínom zápasov. Jeho špecifická časť popisu
je nasledovná:

Na začiatku je počet dátumov. Nasledujú jednotlivé dátumy, vo formáte dd MMM yyyy,
napríklad 05 May 2017 . Za každým dátumom musí končiť riadok.

##### Weekly

Tento plánovač plánuje jeden zápas na týždeň, počnúc daným termínom. Špecifickú časť
popisu tvorí jeden dátum vo formáte dd MMM yyyy: dátum prvého zápasu.
Za dátumom musí končiť riadok.