## Používateľský manuál

### Inštalácia (kompilácia)

Program je písaný v jave, takže ho treba najprv skompilovať. Na
GNU/Linuxoch (so všetkým potrebným nainštalovaným) by mal fungovať 
napríklad príkaz

```
javac $(find . -name "*.java")
```

### Spúšťanie

Program sa spúšťa pomocou

```
java tournament.Application
```

Ak chcete, môžete mu dať ako parameter súbor popisujúci štruktúru
turnaja. Inak bude program tento súbor hľadať pod názvom `groups.txt`.
Spustenie programu bez parametrov je teda ekvivalentné

```
java tournament.Application groups.txt
```

V priečinku examples sú ďalšie ukážkové súbory so štruktúrou, môžete
napríklad vyskúšať

```
java tournament.Application examples/complex.txt
```

### Ovládanie

S programom sa dá komunikovať písaním príkazov do konzoly. Pozná nasledujúce
príkazy:

* `day` -- program odsimuluje jeden deň, vypíše aktuálny dátum a zoznam zápasov, ktoré sa odohrali

* `results [GroupID]` -- vypíše výsledky skupiny s názvom `[GroupID]` (názvy skupín
       sú definované v súboroch so štruktúrou. V ukážkových súboroch sú napríklad skupiny
       GroupA, GroupB, FinalGroup).

* `schedule [GroupID]` -- vypíše zoznam zápasov v danej skupine (odohraných aj neodohraných).

* `exit` -- program skončí.

### Testovanie

Ak sa vám nechce vypisovať dookola príkaz `day` kým sa niečo neudeje, môžete použiť testovací
skript `test.py`. Ak napríklad použijete príkaz

```
python3 test.py | java tournament.Application examples/drawn.txt > output.txt
```

v súbore output.txt by malo byť všetko, čo program vypísal.
