package fifaranking;
import tournament.Team;
import java.util.*;
import java.io.*;

public class StaticRanking implements WorldRanking
{
	private ArrayList<Team> ranking;
	private HashMap<Team, Integer> nameToRank;
	
	private StaticRanking()
	{
		ranking = new ArrayList<Team>();
		nameToRank = new HashMap<Team, Integer>();
		try
		{
			File file = new File("ranking.txt");
			Scanner sc = new Scanner(file);
			int totalTeams = sc.nextInt();
			for(int i=0; i<totalTeams; i++)
			{
				Team team = new Team(sc);
				ranking.add(team);
				nameToRank.put(team, ranking.size());
			}
			sc.close();
		}
		catch (Exception e)
		{
			System.err.println("Failed to load FIFA ranking.");
			e.printStackTrace();
		}
	}
	
	private static class StaticRankingHolder
	{
		private static final StaticRanking instance = new StaticRanking();
	}
	
	public static WorldRanking getInstance()
	{
		return StaticRankingHolder.instance;
	}
	
	@Override
	public Team getIthTeam(int i)
	{
		try
		{
			return ranking.get(i-1);
		}
		catch (IndexOutOfBoundsException e)
		{
			return null;
		}
	}
	
	@Override
	public int getTeamsPosition(Team team)
	{
		Integer result = nameToRank.get(team);
		if(result == null) return -1;
		return result.intValue();
	}
	
}