# Review

Jadro dizajnu je veľmi pekné a prepracované, úplne ho schvaľujem. Detaily a samotná implementácia
však má zopár nedostatkov:

- `Group` a iné triedy a podtriedy implementujú vlastné printovanie. Toto by bolo ešte OK, pokiaľ by
  bolo ovplyvniteľné, kam výstup pôjde. Výstup ide skrátka na `stdout`, čo je veľmi neflexibilné.
  - Navrhujem pridanie argumentu výstupu do printovacích metód.
     
     - [Batmendijn] Fixed

- Abstraktné triedy ako `Group` a `SlotFiller` vedia konštruovať svoje podtriedy. Týmto sa vytvára
  istá cyklická závislosť medzi triedou a podtriedou. Dané podtriedy tým zároveň dostávajú isté
  privilégium: žiadne iné podtriedy potenciálne nie sú tak ľahko načítateľné.
  
  - [Batmendijn] Fixed. V konštruujúcej metóde  `read(Scanner s)` sa správna podtrieda vyberie nie na
    základe hardcodenutého switcha, ale s pomocou reflexie. Pri písaní novej podtriedy teda netreba
    meniť kód abstraktnej triedy, táto nová podtrieda bude môcť byť automaticky generovaná z abstraktnej
    triedy. Strácame tým však možnosť mať pre jednotlivé podtriedy aliasy -- slovo, ktorým sa v súbore
    so štruktúrou turnaja rozlišuje, o akú podtriedu ide, musí presne definovaným spôsobom korešpondovať
    s názvom podtriedy.
    
  
  - Navrhujem oddeliť konštrukciu konkrétnych podtried do nejakej inej triedy, napríklad
    `GroupLoader` alebo niečo podobné. Toto silne súvisí aj s nasledujúcim bodom.
    
    - [Batmendijn] Odmietam návrh, komentár pri nasledujúcom bode.
    

- Skoro všetky triedy sa vedia konštruovať zo `Scanner`-a a niektoré len týmto spôsobom. Väčšina sa
  vie plnohodnotne a jednoducho skonštruovať len týmto spôsobom. Je jasné, kam tým mierim. Bráni to
  vytvoreniu iných spôsobov konštrukcie celej veci, sme skrátka odkazaní na nejaký `Scanner`. To
  však nie je všetko. Všetky tieto "scannerové konštruktory" sú v podstate súčasťou jednej
  roztrieštenej špagetovej načítavacej funkcie.
  
  
  - Navrhujem každej triede pridať konštruktor, ktorý nie je závislý od scannera a príjima len čísté
    dáta, hodnoty. Ďalej odstráni scannerové konštruktory a celú roztrieštenú načítavaciu funkciu
    spojiť do jednej konzistentnej funkcie v nejakej inej triede. Skrátka, nech načítavanie je
    centralizované a oddelené od zvyšku, žiadna magická rekurzia cez všetky súbory.
    
    - [Batmendijn] Problém s centralizáciou načítania je, že pri písaní novej triedy by bolo nutné modifikovať túto
      centrálnu načítaciu triedu. Druhá možnosť by bola pre každú novú podtriedu napísať aj pomocnú podtriedu,
      ktorá ju vie načítať. S pomocou týchto tried by potom mohla existovať centrálna načítacia trieda, ktorá
      by ich používala za pomoci reflexie. V konečnom dôsledku by sme však opäť dostali magickú rekurziu cez
      veľa súborov.
      
      Navyše, keďže pridávanie nových spôsobov načítania nie je smer, ktorým chceme náš dizajn
      rozširovať, je pohodlnejšie mať načítaciu funkciu priamo v triede.
      
      To, že načítacia funkcia je priamo konštruktor, umožňuje pohodlnejšie zdieľanie spoločnej časti načítania
      medzi jednotlivými podtriedami (príkladom je Scannerový konštruktor triedy Group a jej podtried). Principiálne
      to ani nemá dôvod byť niečo iné: od načítacej funkcie chceme presne to, aby vytvorila jednu inštanciu danej triedy.
      
      Absencia iných konštruktorov ako Scannerového je z jediného dôvodu: zatiaľ ich nepotrebujeme a bol by to mŕtvy kód.
    
- Všade je veľa polymorfizmu, čo je super, ale zrazu tam je `StaticRanking`, ktorý je singleton a
  vôbec nepolymorfný. Prečo? `GroupManager` je tiež singleton. A tiež si myslím, že nemusí.
  - Navrhujem, po vyriešení predchadzajúcich bodov sa skutočne zamyslieť, kto všetko závisí od
    rankingu a managera. Tipujem, že nakoniec nebude potrebné ich dávať ako argumenty do všetkých
    funkcii a bude to celkom pekné, keď nebudú singletoni. Určite to bude flexibilnejšie.
    
    - [Batmendijn] GroupManager a DateManager majú byť v podstate globálni (čo sa v jave priamočiaro nedá), preto ich
      ponechávam ako singletony.
      
      WorldRanking (a podobne MatchSimulator) má byť tiež iba jeden, takže singleton podľa mňa dáva zmysel. 
      Čo nedávalo zmysel je, že v kóde bol hardcodenutý jeden konkrétny (StaticRanking). To som vyriešil zavedením 
      novej triedy `External` ktorá si drží referencie na WorldRanking a MatchSimulator, ktoré treba používať. Tie sa určia
      na začiatku v main()-e. Tým pádom nemusia byť hardcodenuté (a vôbec to nemusia byť singletony. Aktuálnu stub implementáciu
      som však nemenil). Trieda `External` je zeroton -- keďže si má iba držať dve globálne referencie, nepotrebujeme ju inštancovať
      a môže v nej byť všetko statické.
